/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities;

import java.util.function.Predicate;
import java.util.function.Supplier;
import net.dries007.tfc.common.capabilities.ItemStackFluidHandler;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class DiscreteItemStackFluidHandler
extends ItemStackFluidHandler {
    public DiscreteItemStackFluidHandler(ItemStack stack, TagKey<Fluid> allowedFluids, Supplier<Integer> capacity) {
        super(stack, allowedFluids, capacity);
    }

    public DiscreteItemStackFluidHandler(ItemStack stack, Predicate<Fluid> allowedFluids, Supplier<Integer> capacity) {
        super(stack, allowedFluids, capacity);
    }

    @Override
    public int fill(FluidStack fill, IFluidHandler.FluidAction action) {
        if (this.fluid.isEmpty() && fill.getAmount() >= (Integer)this.capacity.get() && this.isFluidValid(0, fill)) {
            if (action.execute()) {
                this.fluid = fill.copy();
                this.fluid.setAmount(((Integer)this.capacity.get()).intValue());
                this.save();
            }
            return (Integer)this.capacity.get();
        }
        return 0;
    }

    @Override
    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (!this.fluid.isEmpty() && maxDrain >= (Integer)this.capacity.get()) {
            FluidStack result = this.fluid.copy();
            if (action.execute()) {
                this.fluid = FluidStack.EMPTY;
                this.save();
            }
            return result;
        }
        return FluidStack.EMPTY;
    }
}

