/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.soil;

import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.soil.IMudBlock;
import net.dries007.tfc.common.blocks.soil.SoilBlockType;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.registry.RegistrySoilVariant;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;

public class TFCRootedDirtBlock
extends Block
implements IMudBlock {
    private final Supplier<? extends Block> dirt;
    @Nullable
    private final Supplier<? extends Block> mud;

    public TFCRootedDirtBlock(BlockBehaviour.Properties properties, Supplier<? extends Block> dirt, @Nullable Supplier<? extends Block> mud) {
        super(properties);
        this.dirt = dirt;
        this.mud = mud;
    }

    TFCRootedDirtBlock(BlockBehaviour.Properties properties, SoilBlockType dirtType, RegistrySoilVariant variant) {
        this(properties, variant.getBlock(dirtType), variant.getBlock(SoilBlockType.MUD));
    }

    @Override
    public BlockState getMud() {
        return this.mud.get().m_49966_();
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction action, boolean simulate) {
        if (context.m_43722_().canPerformAction(action) && action == ToolActions.HOE_TILL && ((Boolean)TFCConfig.SERVER.enableRootedDirtToDirtCreation.get()).booleanValue()) {
            return this.dirt.get().m_49966_();
        }
        return null;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.mud != null) {
            return this.transformToMud(this.mud.get().m_49966_(), level, pos, player, hand);
        }
        return InteractionResult.PASS;
    }
}

