/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.soil;

import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public interface IMudBlock {
    public BlockState getMud();

    default public InteractionResult transformToMud(BlockState mud, Level level, BlockPos pos, Player player, InteractionHand hand) {
        FluidStack simulatedDrained;
        if (!((Boolean)TFCConfig.SERVER.enableDirtToMudCreation.get()).booleanValue()) {
            return InteractionResult.PASS;
        }
        ItemStack held = player.m_21120_(hand);
        int waterRequired = 100;
        FluidStack water = new FluidStack((Fluid)Fluids.f_76193_, 100);
        IFluidHandler fluidHandler = (IFluidHandler)Helpers.getCapability((ICapabilityProvider)held, Capabilities.FLUID_ITEM);
        if (fluidHandler != null && (simulatedDrained = fluidHandler.drain(100, IFluidHandler.FluidAction.SIMULATE)).containsFluid(water)) {
            fluidHandler.drain(100, IFluidHandler.FluidAction.EXECUTE);
            level.m_46597_(pos, mud);
            FluidHelpers.playTransferSound(level, pos, water, FluidHelpers.Transfer.DRAIN);
            if (!level.f_46443_) {
                for (int i = 0; i < 5; ++i) {
                    ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123769_, (double)pos.m_123341_() + level.f_46441_.m_188500_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + level.f_46441_.m_188500_(), 1, 0.0, 0.0, 0.0, 1.0);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

