/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.rotation;

import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.rotation.RotatingBlockEntity;
import net.dries007.tfc.common.blockentities.rotation.WindmillBlockEntity;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.blocks.rotation.AxleBlock;
import net.dries007.tfc.common.blocks.rotation.ConnectedAxleBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.advancements.TFCAdvancements;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class WindmillBlock
extends DeviceBlock
implements EntityBlockExtension,
ConnectedAxleBlock {
    public static final IntegerProperty COUNT = TFCBlockStateProperties.COUNT_1_5;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    private final Supplier<? extends AxleBlock> axle;

    public WindmillBlock(ExtendedProperties properties, Supplier<? extends AxleBlock> axle) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.axle = axle;
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)COUNT, (Comparable)Integer.valueOf(1)));
    }

    @Override
    public AxleBlock getAxle() {
        return this.axle.get();
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof RotatingBlockEntity) {
            RotatingBlockEntity entity = (RotatingBlockEntity)blockEntity;
            entity.destroyIfInvalid((Level)level, pos);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        WindmillBlockEntity windmill;
        IItemHandler inventory;
        ItemStack stack = player.m_21120_(hand);
        int count = (Integer)state.m_61143_((Property)COUNT);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof WindmillBlockEntity) || (inventory = Helpers.getCapability((ICapabilityProvider)(windmill = (WindmillBlockEntity)blockEntity), Capabilities.ITEM)) == null) return InteractionResult.PASS;
        if (!stack.m_41619_()) {
            int newCount;
            if (count == 5) {
                return InteractionResult.CONSUME;
            }
            if (!inventory.insertItem(count, stack.m_255036_(1), false).m_41619_()) return InteractionResult.CONSUME;
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            if ((newCount = windmill.updateState()) != 5 || !(player instanceof ServerPlayer)) return InteractionResult.m_19078_((boolean)level.f_46443_);
            ServerPlayer server = (ServerPlayer)player;
            TFCAdvancements.MAX_WINDMILL.trigger(server);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        } else {
            ItemStack removed = inventory.extractItem(count - 1, 1, false);
            if (removed.m_41619_() || player.m_7500_()) return InteractionResult.m_19078_((boolean)level.f_46443_);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)removed);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{AXIS, COUNT}));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return state.m_61143_(AXIS) == Direction.Axis.X ? AxleBlock.SHAPE_X : AxleBlock.SHAPE_Z;
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)TFCItems.WINDMILL_BLADE.get());
    }
}

