/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.rock;

import java.util.Locale;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.rock.AqueductBlock;
import net.dries007.tfc.common.blocks.rock.LooseRockBlock;
import net.dries007.tfc.common.blocks.rock.MossGrowingBlock;
import net.dries007.tfc.common.blocks.rock.MossGrowingSlabBlock;
import net.dries007.tfc.common.blocks.rock.MossGrowingStairsBlock;
import net.dries007.tfc.common.blocks.rock.MossGrowingWallBlock;
import net.dries007.tfc.common.blocks.rock.MossSpreadingBlock;
import net.dries007.tfc.common.blocks.rock.MossSpreadingSlabBlock;
import net.dries007.tfc.common.blocks.rock.MossSpreadingStairBlock;
import net.dries007.tfc.common.blocks.rock.MossSpreadingWallBlock;
import net.dries007.tfc.common.blocks.rock.RockConvertableToAnvilBlock;
import net.dries007.tfc.common.blocks.rock.RockDisplayCategory;
import net.dries007.tfc.common.blocks.rock.RockSpikeBlock;
import net.dries007.tfc.common.blocks.soil.SandBlockType;
import net.dries007.tfc.util.registry.RegistryRock;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.Nullable;

public enum Rock implements RegistryRock
{
    GRANITE(RockDisplayCategory.FELSIC_IGNEOUS_INTRUSIVE, MapColor.f_283947_, SandBlockType.BROWN),
    DIORITE(RockDisplayCategory.INTERMEDIATE_IGNEOUS_INTRUSIVE, MapColor.f_283906_, SandBlockType.WHITE),
    GABBRO(RockDisplayCategory.MAFIC_IGNEOUS_INTRUSIVE, MapColor.f_283818_, SandBlockType.BLACK),
    SHALE(RockDisplayCategory.SEDIMENTARY, MapColor.f_283818_, SandBlockType.BLACK),
    CLAYSTONE(RockDisplayCategory.SEDIMENTARY, MapColor.f_283843_, SandBlockType.BROWN),
    LIMESTONE(RockDisplayCategory.SEDIMENTARY, MapColor.f_283919_, SandBlockType.WHITE),
    CONGLOMERATE(RockDisplayCategory.SEDIMENTARY, MapColor.f_283907_, SandBlockType.GREEN),
    DOLOMITE(RockDisplayCategory.SEDIMENTARY, MapColor.f_283818_, SandBlockType.BLACK),
    CHERT(RockDisplayCategory.SEDIMENTARY, MapColor.f_283895_, SandBlockType.YELLOW),
    CHALK(RockDisplayCategory.SEDIMENTARY, MapColor.f_283942_, SandBlockType.WHITE),
    RHYOLITE(RockDisplayCategory.FELSIC_IGNEOUS_EXTRUSIVE, MapColor.f_283907_, SandBlockType.RED),
    BASALT(RockDisplayCategory.MAFIC_IGNEOUS_EXTRUSIVE, MapColor.f_283927_, SandBlockType.RED),
    ANDESITE(RockDisplayCategory.INTERMEDIATE_IGNEOUS_EXTRUSIVE, MapColor.f_283846_, SandBlockType.RED),
    DACITE(RockDisplayCategory.INTERMEDIATE_IGNEOUS_EXTRUSIVE, MapColor.f_283947_, SandBlockType.RED),
    QUARTZITE(RockDisplayCategory.METAMORPHIC, MapColor.f_283919_, SandBlockType.YELLOW),
    SLATE(RockDisplayCategory.METAMORPHIC, MapColor.f_283825_, SandBlockType.BROWN),
    PHYLLITE(RockDisplayCategory.METAMORPHIC, MapColor.f_283791_, SandBlockType.BROWN),
    SCHIST(RockDisplayCategory.METAMORPHIC, MapColor.f_283778_, SandBlockType.GREEN),
    GNEISS(RockDisplayCategory.METAMORPHIC, MapColor.f_283907_, SandBlockType.GREEN),
    MARBLE(RockDisplayCategory.METAMORPHIC, MapColor.f_283930_, SandBlockType.WHITE);

    public static final Rock[] VALUES;
    private final String serializedName = this.name().toLowerCase(Locale.ROOT);
    private final RockDisplayCategory category;
    private final MapColor color;
    private final SandBlockType sandType;

    private Rock(RockDisplayCategory category, MapColor color, SandBlockType sandType) {
        this.category = category;
        this.color = color;
        this.sandType = sandType;
    }

    public SandBlockType getSandType() {
        return this.sandType;
    }

    @Override
    public RockDisplayCategory displayCategory() {
        return this.category;
    }

    @Override
    public MapColor color() {
        return this.color;
    }

    @Override
    public Supplier<? extends Block> getBlock(BlockType type) {
        return (Supplier)TFCBlocks.ROCK_BLOCKS.get(this).get((Object)type);
    }

    @Override
    public Supplier<? extends Block> getAnvil() {
        return (Supplier)TFCBlocks.ROCK_ANVILS.get(this);
    }

    @Override
    public Supplier<? extends SlabBlock> getSlab(BlockType type) {
        return TFCBlocks.ROCK_DECORATIONS.get(this).get((Object)type).slab();
    }

    @Override
    public Supplier<? extends StairBlock> getStair(BlockType type) {
        return TFCBlocks.ROCK_DECORATIONS.get(this).get((Object)type).stair();
    }

    @Override
    public Supplier<? extends WallBlock> getWall(BlockType type) {
        return TFCBlocks.ROCK_DECORATIONS.get(this).get((Object)type).wall();
    }

    public String m_7912_() {
        return this.serializedName;
    }

    static {
        VALUES = Rock.values();
    }

    public static enum BlockType implements StringRepresentable
    {
        RAW((rock, self) -> RockConvertableToAnvilBlock.createForIgneousOnly(BlockType.properties(rock).m_60913_(rock.category().hardness(6.5f), 10.0f).m_60999_(), rock, false), true),
        HARDENED((rock, self) -> RockConvertableToAnvilBlock.createForIgneousOnly(BlockType.properties(rock).m_60913_(rock.category().hardness(8.0f), 10.0f).m_60999_(), rock, true), false),
        SMOOTH((rock, self) -> new Block(BlockType.properties(rock).m_60913_(rock.category().hardness(6.5f), 10.0f).m_60999_()), true),
        COBBLE((rock, self) -> new MossGrowingBlock(BlockType.properties(rock).m_60913_(rock.category().hardness(5.5f), 10.0f).m_60999_(), rock.getBlock(Objects.requireNonNull(self.mossy()))), true),
        BRICKS((rock, self) -> new MossGrowingBlock(BlockType.properties(rock).m_60913_(rock.category().hardness(6.5f), 10.0f).m_60999_(), rock.getBlock(Objects.requireNonNull(self.mossy()))), true),
        GRAVEL((rock, self) -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(rock.color()).m_60918_(SoundType.f_56739_).m_280658_(NoteBlockInstrument.SNARE).m_60978_(rock.category().hardness(2.0f))), false),
        SPIKE((rock, self) -> new RockSpikeBlock(BlockType.properties(rock).m_60913_(rock.category().hardness(4.0f), 10.0f).m_60999_().m_60953_(TFCBlocks.lavaLoggedBlockEmission())), false),
        CRACKED_BRICKS((rock, self) -> new Block(BlockType.properties(rock).m_60913_(rock.category().hardness(6.5f), 10.0f).m_60999_()), true),
        MOSSY_BRICKS((rock, self) -> new MossSpreadingBlock(BlockType.properties(rock).m_60913_(rock.category().hardness(6.5f), 10.0f).m_60999_()), true),
        MOSSY_COBBLE((rock, self) -> new MossSpreadingBlock(BlockType.properties(rock).m_60913_(rock.category().hardness(6.5f), 10.0f).m_60999_()), true),
        CHISELED((rock, self) -> new Block(BlockType.properties(rock).m_60913_(rock.category().hardness(8.0f), 10.0f).m_60999_()), false),
        LOOSE((rock, self) -> new LooseRockBlock(BlockType.properties(rock).m_60913_(0.05f, 0.0f).m_60910_()), false),
        MOSSY_LOOSE((rock, self) -> new LooseRockBlock(BlockType.properties(rock).m_60913_(0.05f, 0.0f).m_60910_()), false),
        PRESSURE_PLATE((rock, self) -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockType.properties(rock).m_60999_().m_60910_().m_60978_(0.5f), BlockSetType.f_271263_), false),
        BUTTON((rock, self) -> new ButtonBlock(BlockType.properties(rock).m_60910_().m_60978_(0.5f), BlockSetType.f_271263_, 20, false), false),
        AQUEDUCT((rock, self) -> new AqueductBlock(BlockType.properties(rock).m_60913_(rock.category().hardness(6.5f), 10.0f).m_60999_()), false);

        public static final BlockType[] VALUES;
        private final boolean variants;
        private final BiFunction<RegistryRock, BlockType, Block> blockFactory;
        private final String serializedName;

        public static BlockType valueOf(int i) {
            return i >= 0 && i < VALUES.length ? VALUES[i] : RAW;
        }

        private static BlockBehaviour.Properties properties(RegistryRock rock) {
            return BlockBehaviour.Properties.m_284310_().m_284180_(rock.color()).m_60918_(SoundType.f_56742_).m_280658_(NoteBlockInstrument.BASEDRUM);
        }

        private BlockType(BiFunction<RegistryRock, BlockType, Block> blockFactory, boolean variants) {
            this.blockFactory = blockFactory;
            this.variants = variants;
            this.serializedName = this.name().toLowerCase(Locale.ROOT);
        }

        public boolean hasVariants() {
            return this.variants;
        }

        public Block create(RegistryRock rock) {
            return this.blockFactory.apply(rock, this);
        }

        public SlabBlock createSlab(RegistryRock rock) {
            BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60918_(SoundType.f_56742_).m_60913_(1.5f, 10.0f).m_60999_();
            BlockType mossy = this.mossy();
            if (mossy == this) {
                return new MossSpreadingSlabBlock(properties);
            }
            if (mossy != null) {
                return new MossGrowingSlabBlock(properties, rock.getSlab(mossy));
            }
            return new SlabBlock(properties);
        }

        public StairBlock createStairs(RegistryRock rock) {
            Supplier<BlockState> state = () -> rock.getBlock(this).get().m_49966_();
            BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60918_(SoundType.f_56742_).m_60913_(1.5f, 10.0f).m_60999_();
            BlockType mossy = this.mossy();
            if (mossy == this) {
                return new MossSpreadingStairBlock(state, properties);
            }
            if (mossy != null) {
                return new MossGrowingStairsBlock(state, properties, rock.getStair(mossy));
            }
            return new StairBlock(state, properties);
        }

        public WallBlock createWall(RegistryRock rock) {
            BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60918_(SoundType.f_56742_).m_60913_(1.5f, 10.0f).m_60999_();
            BlockType mossy = this.mossy();
            if (mossy == this) {
                return new MossSpreadingWallBlock(properties);
            }
            if (mossy != null) {
                return new MossGrowingWallBlock(properties, rock.getWall(mossy));
            }
            return new WallBlock(properties);
        }

        public String m_7912_() {
            return this.serializedName;
        }

        @Nullable
        private BlockType mossy() {
            return switch (this) {
                case COBBLE, MOSSY_COBBLE -> MOSSY_COBBLE;
                case BRICKS, MOSSY_BRICKS -> MOSSY_BRICKS;
                default -> null;
            };
        }

        static {
            VALUES = BlockType.values();
        }
    }
}

