/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant.fruit;

import com.google.common.base.Preconditions;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TickCounterBlockEntity;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.ISlowEntities;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.plant.PlantBlock;
import net.dries007.tfc.common.blocks.plant.fruit.Lifecycle;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.Month;
import net.dries007.tfc.util.climate.ClimateRange;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public abstract class SeasonalPlantBlock
extends BushBlock
implements IForgeBlockExtension,
EntityBlockExtension,
ISlowEntities {
    public static final VoxelShape PLANT_SHAPE = SeasonalPlantBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final IntegerProperty STAGE = TFCBlockStateProperties.STAGE_2;
    public static final EnumProperty<Lifecycle> LIFECYCLE = TFCBlockStateProperties.LIFECYCLE;
    protected final Supplier<? extends Item> productItem;
    protected final Supplier<ClimateRange> climateRange;
    private final Lifecycle[] lifecycle;
    private final ExtendedProperties properties;

    public static int distanceToGround(Level level, BlockPos pos, int distance) {
        BlockPos.MutableBlockPos mutablePos = pos.m_122032_();
        for (int i = 1; i <= distance; ++i) {
            mutablePos.m_122173_(Direction.DOWN);
            if (Helpers.isBlock(level.m_8055_((BlockPos)mutablePos), TFCTags.Blocks.ANY_SPREADING_BUSH)) continue;
            return i;
        }
        return distance;
    }

    public static boolean checkAndSetDormant(Level level, BlockPos pos, BlockState state, Lifecycle current, Lifecycle expected) {
        if (expected == Lifecycle.DORMANT) {
            if (expected != current) {
                level.m_46597_(pos, (BlockState)state.m_61124_(LIFECYCLE, (Comparable)((Object)Lifecycle.DORMANT)));
            }
            return true;
        }
        return false;
    }

    public static void randomDestroyTick(ServerLevel level, BlockPos pos, int days) {
        TickCounterBlockEntity counter;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TickCounterBlockEntity && (counter = (TickCounterBlockEntity)blockEntity).getTicksSinceUpdate() > 24000L * (long)days) {
            counter.m_7651_();
            level.m_46961_(pos, true);
        }
    }

    public SeasonalPlantBlock(ExtendedProperties properties, Supplier<ClimateRange> climateRange, Supplier<? extends Item> productItem, Lifecycle[] lifecycle) {
        super(properties.properties());
        Preconditions.checkArgument((lifecycle.length == 12 ? 1 : 0) != 0, (Object)"Lifecycle length must be 12");
        this.properties = properties;
        this.climateRange = climateRange;
        this.lifecycle = lifecycle;
        this.productItem = productItem;
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (state.m_61143_(LIFECYCLE) == Lifecycle.FRUITING) {
            level.m_5594_(player, pos, SoundEvents.f_12457_, SoundSource.PLAYERS, 1.0f, level.m_213780_().m_188501_() + 0.7f + 0.3f);
            if (!level.m_5776_()) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.getProductItem(level.f_46441_));
            }
            level.m_46597_(pos, this.stateAfterPicking(state));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public BlockState stateAfterPicking(BlockState state) {
        return (BlockState)state.m_61124_(LIFECYCLE, (Comparable)((Object)Lifecycle.HEALTHY));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Integer)state.m_61143_((Property)STAGE) == 2 ? Shapes.m_83144_() : PLANT_SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity.m_6095_() != EntityType.f_20461_ && Helpers.isBlock((Block)this, TFCTags.Blocks.THORNY_BUSHES)) {
            entity.m_6469_(entity.m_269291_().m_269555_(), 0.5f);
        }
    }

    @Override
    @Nullable
    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob entity) {
        return Helpers.isBlock((Block)this, TFCTags.Blocks.THORNY_BUSHES) ? BlockPathTypes.DAMAGE_OTHER : BlockPathTypes.OPEN;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIFECYCLE, STAGE});
    }

    @Override
    public float slowEntityFactor(BlockState state) {
        float modifier = ((Double)TFCConfig.SERVER.leavesMovementModifier.get()).floatValue();
        if (state.m_61138_((Property)PlantBlock.AGE)) {
            modifier = Mth.m_14179_((float)((1.0f + (float)((Integer)state.m_61143_((Property)PlantBlock.AGE)).intValue()) / 4.0f), (float)1.0f, (float)modifier);
        }
        if (state.m_61138_((Property)STAGE)) {
            modifier = Mth.m_14179_((float)((float)(1 + (Integer)state.m_61143_((Property)STAGE)) / 3.0f), (float)1.0f, (float)modifier);
        }
        return modifier;
    }

    public ItemStack getProductItem(RandomSource random) {
        return new ItemStack((ItemLike)this.productItem.get());
    }

    protected Lifecycle getLifecycleForCurrentMonth() {
        return this.getLifecycleForMonth(Calendars.SERVER.getCalendarMonthOfYear());
    }

    protected Lifecycle getLifecycleForMonth(Month month) {
        return this.lifecycle[month.ordinal()];
    }

    protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return Helpers.isBlock(level.m_8055_(pos), TFCTags.Blocks.BUSH_PLANTABLE_ON);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos belowPos = pos.m_7495_();
        return this.m_6266_(level.m_8055_(belowPos), (BlockGetter)level, belowPos);
    }
}

