/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant.fruit;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TickCounterBlockEntity;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.plant.fruit.FruitTreeBranchBlock;
import net.dries007.tfc.common.blocks.plant.fruit.FruitTreeLeavesBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.climate.ClimateRange;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class GrowingFruitTreeBranchBlock
extends FruitTreeBranchBlock
implements EntityBlockExtension {
    public static final IntegerProperty SAPLINGS = TFCBlockStateProperties.SAPLINGS;
    public static final BooleanProperty NATURAL = TFCBlockStateProperties.NATURAL;
    private static final Direction[] NOT_DOWN = new Direction[]{Direction.WEST, Direction.EAST, Direction.SOUTH, Direction.NORTH, Direction.UP};
    private final Supplier<? extends Block> body;
    private final Supplier<? extends Block> leaves;
    private final Supplier<ClimateRange> climateRange;

    private static boolean canGrowInto(LevelReader level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return state.m_60795_() || Helpers.isBlock(state, TFCTags.Blocks.FRUIT_TREE_LEAVES);
    }

    private static boolean allNeighborsEmpty(LevelReader level, BlockPos pos, @Nullable Direction excludingSide) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            mutablePos.m_122190_((Vec3i)pos).m_122173_(direction);
            if (direction == excludingSide || GrowingFruitTreeBranchBlock.canGrowInto(level, (BlockPos)mutablePos)) continue;
            return false;
        }
        return true;
    }

    public GrowingFruitTreeBranchBlock(ExtendedProperties properties, Supplier<? extends Block> body, Supplier<? extends Block> leaves, Supplier<ClimateRange> climateRange) {
        super(properties, climateRange);
        this.body = body;
        this.leaves = leaves;
        this.climateRange = climateRange;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_55148_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_55149_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_55150_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_55151_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_55152_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_55153_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)STAGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)NATURAL, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void addExtraInfo(List<Component> text) {
        text.add((Component)Component.m_237115_((String)"tfc.tooltip.fruit_tree.growing"));
    }

    public void grow(BlockState state, ServerLevel level, BlockPos pos, RandomSource random, int cyclesLeft) {
        int stage;
        FruitTreeBranchBlock body = (FruitTreeBranchBlock)this.body.get();
        BlockPos abovePos = pos.m_7494_();
        boolean natural = (Boolean)state.m_61143_((Property)NATURAL);
        if (GrowingFruitTreeBranchBlock.canGrowInto((LevelReader)level, abovePos) && abovePos.m_123342_() < level.m_151558_() - 1 && (stage = ((Integer)state.m_61143_((Property)STAGE)).intValue()) < 3) {
            boolean willGrowUpward = false;
            BlockState belowState = level.m_8055_(pos.m_7495_());
            Block belowBlock = belowState.m_60734_();
            if (Helpers.isBlock(belowBlock, TFCTags.Blocks.BUSH_PLANTABLE_ON)) {
                willGrowUpward = true;
            } else if (belowBlock == body) {
                BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
                int j = 1;
                for (int k = 0; k < 4; ++k) {
                    mutablePos.m_122154_((Vec3i)pos, 0, -1 * (j + 1), 0);
                    if (level.m_8055_((BlockPos)mutablePos).m_60734_() != body) break;
                    ++j;
                }
                if (j < 2) {
                    willGrowUpward = true;
                }
            } else if (GrowingFruitTreeBranchBlock.canGrowInto((LevelReader)level, pos.m_7495_())) {
                willGrowUpward = true;
            }
            if (willGrowUpward && GrowingFruitTreeBranchBlock.allNeighborsEmpty((LevelReader)level, abovePos, null) && GrowingFruitTreeBranchBlock.canGrowInto((LevelReader)level, pos.m_6630_(2))) {
                this.placeBody((LevelAccessor)level, pos, stage);
                this.placeGrownFlower(level, abovePos, stage, (Integer)state.m_61143_((Property)SAPLINGS), cyclesLeft - 1, natural);
            } else if (stage < 2) {
                int branches = Math.max(0, (Integer)state.m_61143_((Property)SAPLINGS) - stage);
                BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
                List directions = Direction.Plane.HORIZONTAL.m_122557_().collect(Collectors.toList());
                while (branches > 0) {
                    Direction test = Direction.Plane.HORIZONTAL.m_235690_(random);
                    if (!directions.contains(test)) continue;
                    if (GrowingFruitTreeBranchBlock.couldBranchInDirection(level, pos, mutablePos, test)) {
                        boolean doubleBranch = false;
                        if (random.m_188499_()) {
                            mutablePos.m_122175_(test, 1);
                            if (GrowingFruitTreeBranchBlock.couldBranchInDirection(level, pos, mutablePos, test)) {
                                mutablePos.m_122175_(test, -1);
                                this.placeBody((LevelAccessor)level, (BlockPos)mutablePos, stage);
                                mutablePos.m_122175_(test, 1);
                                this.placeGrownFlower(level, (BlockPos)mutablePos, stage + 1, (Integer)state.m_61143_((Property)SAPLINGS), cyclesLeft - 1, natural);
                                doubleBranch = true;
                            }
                        }
                        if (!doubleBranch) {
                            this.placeGrownFlower(level, (BlockPos)mutablePos, stage + 1, (Integer)state.m_61143_((Property)SAPLINGS), cyclesLeft - 1, natural);
                        }
                    }
                    directions.remove(test);
                    --branches;
                }
                this.placeBody((LevelAccessor)level, pos, stage);
            } else {
                this.placeBody((LevelAccessor)level, pos, stage);
            }
        }
    }

    private static boolean couldBranchInDirection(ServerLevel level, BlockPos pos, BlockPos.MutableBlockPos mutablePos, Direction test) {
        mutablePos.m_122159_((Vec3i)pos, test);
        if (GrowingFruitTreeBranchBlock.canGrowInto((LevelReader)level, (BlockPos)mutablePos)) {
            mutablePos.m_122184_(0, -1, 0);
            if (GrowingFruitTreeBranchBlock.canGrowInto((LevelReader)level, (BlockPos)mutablePos)) {
                mutablePos.m_122184_(0, 1, 0);
                return GrowingFruitTreeBranchBlock.allNeighborsEmpty((LevelReader)level, (BlockPos)mutablePos, test.m_122424_());
            }
        }
        return false;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{SAPLINGS, NATURAL}));
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)STAGE) < 3;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int hydration = FruitTreeLeavesBlock.getHydration((Level)level, pos);
        float temp = Climate.getAverageTemperature((Level)level, pos);
        if (!this.climateRange.get().checkBoth(hydration, temp, false) && !((Boolean)state.m_61143_((Property)NATURAL)).booleanValue()) {
            TickCounterBlockEntity.reset((Level)level, pos);
        }
        super.m_213898_(state, level, pos, random);
    }

    @Override
    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        TickCounterBlockEntity counter;
        long days;
        int cycles;
        super.m_213897_(state, level, pos, rand);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TickCounterBlockEntity && (cycles = (int)((days = (counter = (TickCounterBlockEntity)blockEntity).getTicksSinceUpdate() / 24000L) / 5L)) >= 1) {
            this.grow(state, level, pos, rand, cycles);
            counter.resetCounter();
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return ItemStack.f_41583_;
    }

    private void placeGrownFlower(ServerLevel level, BlockPos pos, int stage, int saplings, int cycles, boolean natural) {
        level.m_7731_(pos, (BlockState)((BlockState)((BlockState)this.getStateForPlacement((BlockGetter)level, pos).m_61124_((Property)STAGE, (Comparable)Integer.valueOf(stage))).m_61124_((Property)SAPLINGS, (Comparable)Integer.valueOf(saplings))).m_61124_((Property)NATURAL, (Comparable)Boolean.valueOf(natural)), 3);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TickCounterBlockEntity) {
            TickCounterBlockEntity counter = (TickCounterBlockEntity)blockEntity;
            counter.resetCounter();
            counter.reduceCounter(-24000L * (long)cycles * 5L);
        }
        this.addLeaves((LevelAccessor)level, pos);
        level.m_8055_(pos).m_222972_(level, pos, level.f_46441_);
    }

    private void placeBody(LevelAccessor level, BlockPos pos, int stage) {
        FruitTreeBranchBlock plant = (FruitTreeBranchBlock)this.body.get();
        level.m_7731_(pos, (BlockState)plant.getStateForPlacement((BlockGetter)level, pos).m_61124_((Property)STAGE, (Comparable)Integer.valueOf(stage)), 3);
        this.addLeaves(level, pos);
    }

    private void addLeaves(LevelAccessor level, BlockPos pos) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        BlockState leaves = this.leaves.get().m_49966_();
        mutablePos.m_122154_((Vec3i)pos, 0, -2, 0);
        BlockState downState = level.m_8055_((BlockPos)mutablePos);
        if (!(downState.m_60795_() || Helpers.isBlock(downState, TFCTags.Blocks.FRUIT_TREE_LEAVES) || Helpers.isBlock(downState, TFCTags.Blocks.FRUIT_TREE_BRANCH))) {
            return;
        }
        for (Direction d : NOT_DOWN) {
            mutablePos.m_122159_((Vec3i)pos, d);
            if (!level.m_46859_((BlockPos)mutablePos)) continue;
            level.m_7731_((BlockPos)mutablePos, leaves, 2);
        }
    }
}

