/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant.coral;

import net.dries007.tfc.common.TFCDamageSources;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.entities.aquatic.AquaticMob;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TFCCoralPlantBlock
extends Block
implements IFluidLoggable {
    public static final FluidProperty FLUID = TFCBlockStateProperties.SALT_WATER;
    public static final VoxelShape SMALL_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    public static final VoxelShape BIG_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0);
    private final VoxelShape shape;

    public TFCCoralPlantBlock(VoxelShape shape, BlockBehaviour.Properties properties) {
        super(properties);
        this.shape = shape;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluid = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyForOrEmpty(fluid.m_76152_()));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{this.getFluidProperty()}));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        FluidHelpers.tickFluid(level, currentPos, state);
        return facing == Direction.DOWN && !this.m_7898_(state, (LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public FluidState m_5888_(BlockState state) {
        return IFluidLoggable.super.getFluidLoggedState(state);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos posBelow = pos.m_7495_();
        return level.m_8055_(posBelow).m_60783_((BlockGetter)level, posBelow, Direction.UP);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shape;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!(entity instanceof AquaticMob)) {
            TFCDamageSources.coral(entity, 0.5f);
        }
    }

    @Override
    public FluidProperty getFluidProperty() {
        return FLUID;
    }

    protected void tryScheduleDieTick(BlockState state, LevelAccessor level, BlockPos pos) {
        if (!this.scanForWater(state, (BlockGetter)level, pos)) {
            level.m_186460_(pos, (Block)this, 60 + level.m_213780_().m_188503_(40));
        }
    }

    protected boolean scanForWater(BlockState state, BlockGetter level, BlockPos pos) {
        if (Helpers.isFluid(((FluidProperty.FluidKey)state.m_61143_((Property)this.getFluidProperty())).getFluid(), TFCTags.Fluids.ANY_WATER)) {
            return true;
        }
        for (Direction direction : Helpers.DIRECTIONS) {
            if (!Helpers.isFluid(level.m_6425_(pos.m_121945_(direction)), TFCTags.Fluids.ANY_WATER)) continue;
            return true;
        }
        return false;
    }
}

