/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.plant.BodyPlantBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class TFCKelpBlock
extends BodyPlantBlock
implements IFluidLoggable {
    private final Supplier<? extends Block> headBlock;

    public static TFCKelpBlock create(BlockBehaviour.Properties properties, Supplier<? extends Block> headBlock, Direction direction, VoxelShape shape, final FluidProperty fluid) {
        return new TFCKelpBlock(ExtendedProperties.of(properties.lootFrom(headBlock)), headBlock, shape, direction){

            @Override
            public FluidProperty getFluidProperty() {
                return fluid;
            }
        };
    }

    protected TFCKelpBlock(ExtendedProperties properties, Supplier<? extends Block> headBlock, VoxelShape shape, Direction direction) {
        super(properties, headBlock, shape, direction);
        this.headBlock = headBlock;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        Block block;
        if (facing == this.f_53859_.m_122424_() && !state.m_60710_((LevelReader)level, currentPos)) {
            level.m_186460_(currentPos, (Block)this, 1);
        }
        GrowingPlantHeadBlock topBlock = this.m_7272_();
        if (facing == this.f_53859_ && (block = facingState.m_60734_()) != this && block != topBlock) {
            return (BlockState)topBlock.m_7722_(level).m_61124_((Property)this.getFluidProperty(), (Comparable)((FluidProperty.FluidKey)state.m_61143_((Property)this.getFluidProperty())));
        }
        if (this.f_53860_) {
            FluidHelpers.tickFluid(level, currentPos, state);
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public FluidState m_5888_(BlockState state) {
        return IFluidLoggable.super.getFluidLoggedState(state);
    }

    @Override
    public boolean m_6044_(BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        return false;
    }

    @Override
    public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape voxelshape = super.m_5940_(state, level, pos, context);
        Vec3 vector3d = state.m_60824_(level, pos);
        return voxelshape.m_83216_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{this.getFluidProperty()});
    }

    @Override
    public ItemStack m_142598_(LevelAccessor worldIn, BlockPos pos, BlockState state) {
        return ItemStack.f_41583_;
    }

    @Override
    protected GrowingPlantHeadBlock m_7272_() {
        return (GrowingPlantHeadBlock)this.headBlock.get();
    }
}

