/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import net.dries007.tfc.common.blocks.DirectionPropertyBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class PipePlantBlock
extends PipeBlock
implements IForgeBlockExtension {
    private final ExtendedProperties properties;

    public PipePlantBlock(float size, ExtendedProperties properties) {
        super(size, properties.properties());
        this.properties = properties;
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{f_55148_, f_55149_, f_55150_, f_55151_, f_55152_, f_55153_}));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (!state.m_60710_((LevelReader)level, currentPos)) {
            level.m_186460_(currentPos, (Block)this, 1);
            return state;
        }
        boolean exists = facing.m_122434_().m_122479_() && this.testHorizontal(facingState) || facing == Direction.DOWN && this.testDown(facingState) || facing == Direction.UP && this.testUp(facingState);
        return (BlockState)state.m_61124_((Property)f_55154_.get(facing), (Comparable)Boolean.valueOf(exists));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getStateForPlacement((BlockGetter)context.m_43725_(), context.m_8083_());
    }

    public BlockState getStateForPlacement(BlockGetter level, BlockPos pos) {
        BlockState down = level.m_8055_(pos.m_7495_());
        BlockState up = level.m_8055_(pos.m_7494_());
        BlockState north = level.m_8055_(pos.m_122012_());
        BlockState east = level.m_8055_(pos.m_122029_());
        BlockState south = level.m_8055_(pos.m_122019_());
        BlockState west = level.m_8055_(pos.m_122024_());
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_55153_, (Comparable)Boolean.valueOf(this.testDown(down)))).m_61124_((Property)f_55152_, (Comparable)Boolean.valueOf(this.testUp(up)))).m_61124_((Property)f_55148_, (Comparable)Boolean.valueOf(this.testHorizontal(north)))).m_61124_((Property)f_55151_, (Comparable)Boolean.valueOf(this.testHorizontal(west)))).m_61124_((Property)f_55149_, (Comparable)Boolean.valueOf(this.testHorizontal(east)))).m_61124_((Property)f_55150_, (Comparable)Boolean.valueOf(this.testHorizontal(south)));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            cursor.m_122159_((Vec3i)pos, direction);
            if (!this.testHorizontal(level.m_8055_((BlockPos)cursor))) continue;
            cursor.m_122184_(0, -1, 0);
            if (this.testDown(level.m_8055_((BlockPos)cursor))) {
                return true;
            }
            if (!this.canGrowLongSideways()) continue;
            cursor.m_122184_(0, 1, 0);
            cursor.m_122173_(direction);
            if (!this.testHorizontal(level.m_8055_((BlockPos)cursor))) continue;
            return true;
        }
        cursor.m_122154_((Vec3i)pos, 0, -1, 0);
        return this.testDown(level.m_8055_((BlockPos)cursor));
    }

    protected abstract boolean testDown(BlockState var1);

    protected abstract boolean testUp(BlockState var1);

    protected abstract boolean testHorizontal(BlockState var1);

    protected boolean canGrowLongSideways() {
        return false;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return DirectionPropertyBlock.rotate(state, rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return DirectionPropertyBlock.mirror(state, mirror);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        }
    }
}

