/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import net.dries007.tfc.common.blocks.ExtendedBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.devices.BottomSupportedDeviceBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class KrummholzBlock
extends ExtendedBlock {
    public static final VoxelShape NORMAL_SHAPE = KrummholzBlock.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final VoxelShape TIP_SHAPE = KrummholzBlock.m_49796_((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)12.0, (double)9.5);
    public static final VoxelShape SNOW_SHAPE = KrummholzBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    public static final VoxelShape NORMAL_WITH_SNOW_SHAPE = Shapes.m_83110_((VoxelShape)NORMAL_SHAPE, (VoxelShape)SNOW_SHAPE);
    public static final VoxelShape TIP_WITH_SNOW_SHAPE = Shapes.m_83110_((VoxelShape)TIP_SHAPE, (VoxelShape)SNOW_SHAPE);
    public static final BooleanProperty TIP = TFCBlockStateProperties.TIP;
    public static final BooleanProperty SNOWY = BlockStateProperties.f_61451_;
    public static final BooleanProperty BOTTOM = TFCBlockStateProperties.BOTTOM;

    public static void updateFreezingInColumn(LevelAccessor level, BlockPos pos, boolean frozen) {
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        BlockState state = level.m_8055_(pos);
        cursor.m_122190_((Vec3i)pos);
        while (state.m_60734_() instanceof KrummholzBlock) {
            if ((Boolean)state.m_61143_((Property)SNOWY) != frozen) {
                level.m_7731_((BlockPos)cursor, (BlockState)state.m_61122_((Property)SNOWY), 2);
            }
            cursor.m_122184_(0, -1, 0);
            state = level.m_8055_((BlockPos)cursor);
        }
    }

    public KrummholzBlock(ExtendedProperties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)TIP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SNOWY, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack held = player.m_21120_(hand);
        if (held.m_41720_() == Items.f_41979_ && !((Boolean)state.m_61143_((Property)SNOWY)).booleanValue()) {
            level.m_46597_(pos, (BlockState)state.m_61122_((Property)SNOWY));
            held.m_41774_(1);
            Helpers.playPlaceSound((LevelAccessor)level, pos, SoundType.f_56747_);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (facing == Direction.DOWN && !state.m_60710_((LevelReader)level, pos)) {
            level.m_186460_(pos, (Block)this, 1);
        } else {
            if (facing == Direction.DOWN) {
                return (BlockState)state.m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(facingState.m_60734_() != this));
            }
            if (facing == Direction.UP) {
                return (BlockState)state.m_61124_((Property)TIP, (Comparable)Boolean.valueOf(facingState.m_60734_() != this));
            }
        }
        return state;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)TIP, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(context.m_43725_().m_8055_(context.m_8083_().m_7495_()).m_60734_() != this));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState below = level.m_8055_(pos.m_7495_());
        return below.m_60734_() == this || BottomSupportedDeviceBlock.canSurvive(level, pos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        boolean addSnow;
        boolean bl = addSnow = (Boolean)state.m_61143_((Property)BOTTOM) != false && (Boolean)state.m_61143_((Property)SNOWY) != false;
        return ((Boolean)state.m_61143_((Property)TIP)).booleanValue() ? (addSnow ? TIP_WITH_SNOW_SHAPE : TIP_SHAPE) : (addSnow ? NORMAL_WITH_SNOW_SHAPE : NORMAL_SHAPE);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{TIP, SNOWY, BOTTOM}));
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public boolean m_180643_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return false;
    }
}

