/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.ScrapingBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ScrapingBlock
extends DeviceBlock {
    private static final VoxelShape SHAPE = ScrapingBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final Vec3 PLANE_NORMAL = new Vec3(0.0, 1.0, 0.0);
    public static final BooleanProperty WAXED = TFCBlockStateProperties.WAXED;

    private static Vec3 calculatePoint(Vec3 rayVector, Vec3 rayPoint) {
        return rayPoint.m_82546_(rayVector.m_82490_(rayPoint.m_82526_(PLANE_NORMAL) / rayVector.m_82526_(PLANE_NORMAL)));
    }

    public ScrapingBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)WAXED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN && !Helpers.isBlock(facingState, TFCTags.Blocks.SCRAPING_SURFACE)) {
            return Blocks.f_50016_.m_49966_();
        }
        return stateIn;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (Helpers.isItem(stack, TFCTags.Items.WAXES_SCRAPING_SURFACE) && !((Boolean)state.m_61143_((Property)WAXED)).booleanValue()) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)WAXED, (Comparable)Boolean.valueOf(true)));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ScrapingBlockEntity) {
            ScrapingBlockEntity scraping = (ScrapingBlockEntity)blockEntity;
            Vec3 point = ScrapingBlock.calculatePoint(player.m_20154_(), hit.m_82450_().m_82546_(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())));
            if (((Boolean)state.m_61143_((Property)WAXED)).booleanValue()) {
                DyeColor color = DyeColor.getColor((ItemStack)stack);
                if (color != null && scraping.dye(color)) {
                    ScrapingBlock.doParticles(level, pos, scraping, point);
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
            } else if (Helpers.isItem(stack.m_41720_(), TFCTags.Items.KNIVES)) {
                scraping.onClicked((float)point.f_82479_, (float)point.f_82481_);
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                ScrapingBlock.doParticles(level, pos, scraping, point);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    private static void doParticles(Level level, BlockPos pos, ScrapingBlockEntity scraping, Vec3 point) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            scraping.getCapability(Capabilities.ITEM).ifPresent(cap -> server.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, cap.getStackInSlot(0)), (double)pos.m_123341_() + point.f_82479_, (double)pos.m_123342_() + 0.0625, (double)pos.m_123343_() + point.f_82481_, 2, (double)Helpers.triangle(level.f_46441_) / 2.0, level.f_46441_.m_188500_() / 4.0, (double)Helpers.triangle(level.f_46441_) / 2.0, (double)0.15f));
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{WAXED}));
    }
}

