/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import com.mojang.blaze3d.vertex.PoseStack;
import net.dries007.tfc.client.IHighlightHandler;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.QuernBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class QuernBlock
extends DeviceBlock
implements IHighlightHandler {
    private static final VoxelShape BASE_SHAPE = QuernBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
    private static final AABB BASE_AABB = BASE_SHAPE.m_83215_().m_82400_(0.01);
    private static final VoxelShape HANDSTONE_SHAPE = QuernBlock.m_49796_((double)3.0, (double)10.0, (double)3.0, (double)13.0, (double)13.76, (double)13.0);
    private static final AABB HANDSTONE_AABB = HANDSTONE_SHAPE.m_83215_().m_82400_(0.01);
    private static final Vec3 HANDSTONE_CENTER = HANDSTONE_SHAPE.m_83215_().m_82399_();
    private static final VoxelShape HANDLE_SHAPE = QuernBlock.m_49796_((double)4.34, (double)13.76, (double)4.34, (double)5.36, (double)16.24, (double)5.36);
    private static final AABB HANDLE_AABB = HANDLE_SHAPE.m_83215_().m_82400_(0.01);
    private static final VoxelShape INPUT_SLOT_SHAPE = QuernBlock.m_49796_((double)6.0, (double)13.76, (double)6.0, (double)10.0, (double)16.24, (double)10.0);
    private static final AABB INPUT_SLOT_AABB = INPUT_SLOT_SHAPE.m_83215_().m_82400_(0.01);
    private static final VoxelShape FULL_SHAPE = Shapes.m_83113_((VoxelShape)Shapes.m_83124_((VoxelShape)BASE_SHAPE, (VoxelShape[])new VoxelShape[]{HANDSTONE_SHAPE, HANDLE_SHAPE}), (VoxelShape)INPUT_SLOT_SHAPE, (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape COLLISION_FULL_SHAPE = Shapes.m_83110_((VoxelShape)BASE_SHAPE, (VoxelShape)HANDSTONE_SHAPE);
    public static final BooleanProperty HAS_HANDSTONE = TFCBlockStateProperties.HAS_HANDSTONE;

    private static SelectionPlace getPlayerSelection(BlockGetter level, BlockPos pos, Player player, BlockHitResult result) {
        return level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.QUERN.get()).flatMap(quern -> quern.getCapability(Capabilities.ITEM).map(inventory -> {
            ItemStack held = player.m_21120_(InteractionHand.MAIN_HAND);
            Vec3 hit = result.m_82450_();
            if (quern.hasHandstone()) {
                if (!quern.isGrinding() && HANDLE_AABB.m_82338_(pos).m_82390_(hit)) {
                    return SelectionPlace.HANDLE;
                }
                if (!quern.isGrinding() && !held.m_41619_() || !inventory.getStackInSlot(1).m_41619_() && INPUT_SLOT_AABB.m_82338_(pos).m_82390_(hit)) {
                    return SelectionPlace.INPUT_SLOT;
                }
            }
            if ((quern.hasHandstone() || quern.isItemValid(0, held)) && HANDSTONE_AABB.m_82338_(pos).m_82390_(hit)) {
                return SelectionPlace.HANDSTONE;
            }
            return SelectionPlace.BASE;
        })).orElse(SelectionPlace.BASE);
    }

    private static InteractionResult insertOrExtract(Level level, QuernBlockEntity quern, IItemHandler inventory, Player player, ItemStack stack, int slot) {
        if (!stack.m_41619_()) {
            player.m_21008_(InteractionHand.MAIN_HAND, inventory.insertItem(slot, stack, false));
        } else {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)inventory.extractItem(slot, inventory.getStackInSlot(slot).m_41613_(), false));
            if (slot == 0) {
                QuernBlock.insertOrExtract(level, quern, inventory, player, ItemStack.f_41583_, 1);
            }
        }
        quern.setAndUpdateSlots(slot);
        quern.markForSync();
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public QuernBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)HAS_HANDSTONE, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{HAS_HANDSTONE}));
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        QuernBlockEntity quern;
        float rotationSpeed;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof QuernBlockEntity && (rotationSpeed = (quern = (QuernBlockEntity)blockEntity).getRotationSpeed()) != 0.0f && HANDSTONE_AABB.m_82338_(pos).m_82390_(entity.m_20182_()) && !BASE_AABB.m_82390_(entity.m_20182_())) {
            Helpers.rotateEntity(level, entity, HANDSTONE_CENTER.m_82520_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), -rotationSpeed * 57.295776f);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        QuernBlockEntity quern;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof QuernBlockEntity && !(quern = (QuernBlockEntity)blockEntity).isGrinding()) {
            ItemStack heldStack = player.m_21120_(hand);
            SelectionPlace selection = QuernBlock.getPlayerSelection((BlockGetter)level, pos, player, hit);
            return quern.getCapability(Capabilities.ITEM).map(inventory -> switch (selection) {
                default -> throw new IncompatibleClassChangeError();
                case SelectionPlace.HANDLE -> this.attemptGrind(level, pos, quern);
                case SelectionPlace.INPUT_SLOT -> QuernBlock.insertOrExtract(level, quern, inventory, player, heldStack, 1);
                case SelectionPlace.HANDSTONE -> {
                    if (player.m_6144_() || Helpers.isItem(heldStack, TFCTags.Items.HANDSTONE)) {
                        yield QuernBlock.insertOrExtract(level, quern, inventory, player, heldStack, 0);
                    }
                    yield this.attemptGrind(level, pos, quern);
                }
                case SelectionPlace.BASE -> QuernBlock.insertOrExtract(level, quern, inventory, player, ItemStack.f_41583_, 2);
            }).orElse(InteractionResult.PASS);
        }
        return InteractionResult.PASS;
    }

    @NotNull
    private InteractionResult attemptGrind(Level level, BlockPos pos, QuernBlockEntity quern) {
        return !quern.isConnectedToNetwork() && quern.startGrinding() ? InteractionResult.m_19078_((boolean)level.f_46443_) : InteractionResult.FAIL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)HAS_HANDSTONE) != false ? FULL_SHAPE : BASE_SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)HAS_HANDSTONE) != false ? COLLISION_FULL_SHAPE : BASE_SHAPE;
    }

    @Override
    public boolean drawHighlight(Level level, BlockPos pos, Player player, BlockHitResult rayTrace, PoseStack poseStack, MultiBufferSource buffers, Vec3 renderPos) {
        SelectionPlace selection = QuernBlock.getPlayerSelection((BlockGetter)level, pos, player, rayTrace);
        if (selection != SelectionPlace.BASE) {
            IHighlightHandler.drawBox(poseStack, selection.shape, buffers, pos, renderPos, 1.0f, 0.0f, 0.0f, 0.4f);
            return true;
        }
        return false;
    }

    private static enum SelectionPlace {
        HANDLE(HANDLE_SHAPE),
        HANDSTONE(HANDSTONE_SHAPE),
        INPUT_SLOT(INPUT_SLOT_SHAPE),
        BASE(BASE_SHAPE);

        final VoxelShape shape;

        private SelectionPlace(VoxelShape shape) {
            this.shape = shape;
        }
    }
}

