/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.blockentities.PowderkegBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.SealableDeviceBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PowderkegBlock
extends SealableDeviceBlock {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    private static final VoxelShape SHAPE = PowderkegBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape SHAPE_UNSEALED = Shapes.m_83113_((VoxelShape)SHAPE, (VoxelShape)PowderkegBlock.m_49796_((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.f_82685_);
    private static final int[] IMAGE_TOOLTIP = new int[]{4, 3, 0, 11};

    public static void toggleSeal(Level level, BlockPos pos, BlockState state) {
        level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.POWDERKEG.get()).ifPresent(powderkeg -> {
            boolean previousSealed = (Boolean)state.m_61143_((Property)SEALED);
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)SEALED, (Comparable)Boolean.valueOf(!previousSealed)));
            if (previousSealed) {
                powderkeg.onUnseal();
            } else {
                powderkeg.onSeal();
            }
        });
    }

    public PowderkegBlock(ExtendedProperties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)SEALED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PowderkegBlockEntity) {
            PowderkegBlockEntity powderkeg = (PowderkegBlockEntity)blockEntity;
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_41619_() && player.m_6144_()) {
                if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                    powderkeg.setLit(false, (Entity)player);
                    Helpers.playSound(level, pos, SoundEvents.f_11937_);
                } else {
                    PowderkegBlock.toggleSeal(level, pos, state);
                    Helpers.playPlaceSound((LevelAccessor)level, pos, state);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (!level.m_5776_() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Helpers.openScreen(serverPlayer, (MenuProvider)powderkeg, powderkeg.m_58899_());
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public int[] getImageTooltipParameters() {
        return IMAGE_TOOLTIP;
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        if (!((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.POWDERKEG.get()).ifPresent(keg -> keg.setLit(true, explosion.getExploder()));
        }
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            int count = random.m_188503_(3) + 5;
            for (int i = 0; i < count; ++i) {
                double x = (float)pos.m_123341_() + random.m_188501_();
                double z = (float)pos.m_123343_() + random.m_188501_();
                double y = (float)pos.m_123342_() + 0.98f + random.m_188501_() / 5.0f;
                level.m_7106_((ParticleOptions)TFCParticles.SPARK.get(), x, y, z, (double)Helpers.uniform(random, -5.0f, 5.0f), (double)(3.0f + random.m_188501_()), (double)Helpers.uniform(random, -5.0f, 5.0f));
            }
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{LIT}));
    }

    public boolean canDropFromExplosion(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return false;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (level.m_276867_(pos) && !((Boolean)state.m_61143_((Property)LIT)).booleanValue() && ((Boolean)state.m_61143_((Property)SEALED)).booleanValue()) {
            level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.POWDERKEG.get()).ifPresent(keg -> keg.setLit(true, null));
        }
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)SEALED) != false ? SHAPE : SHAPE_UNSEALED;
    }
}

