/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import net.dries007.tfc.common.blockentities.LampBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickCounterBlockEntity;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.advancements.TFCAdvancements;
import net.dries007.tfc.util.loot.CopyFluidFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class LampBlock
extends ExtendedBlock
implements EntityBlockExtension {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final BooleanProperty HANGING = BlockStateProperties.f_61435_;
    protected static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0), (VoxelShape)Block.m_49796_((double)6.0, (double)7.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0));
    protected static final VoxelShape HANGING_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), (VoxelShape)Block.m_49796_((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0));

    private static Direction getConnectedDirection(BlockState state) {
        return (Boolean)state.m_61143_((Property)HANGING) != false ? Direction.DOWN : Direction.UP;
    }

    public LampBlock(ExtendedProperties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.LAMP.get()).ifPresent(LampBlockEntity::checkHasRanOut);
    }

    public boolean m_6724_(BlockState state) {
        return (Boolean)state.m_61143_((Property)LIT);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.LAMP.get()).ifPresent(TickCounterBlockEntity::resetCounter);
        super.m_6402_(level, pos, state, placer, stack);
    }

    public InteractionResult m_6227_(BlockState originalState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        @Nullable LampBlockEntity lamp = level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.LAMP.get()).orElse(null);
        if (lamp != null) {
            lamp.checkHasRanOut();
            BlockState state = level.m_8055_(pos);
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_41619_() && player.m_6144_() && ((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                Helpers.playSound(level, pos, SoundEvents.f_11937_);
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
                lamp.resetCounter();
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (FluidHelpers.transferBetweenBlockEntityAndItem(stack, lamp, player, hand)) {
                lamp.markForSync();
                if (lamp.getFuel() != null && lamp.getFuel().getBurnRate() == -1 && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    TFCAdvancements.LAVA_LAMP.trigger(serverPlayer);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        ItemStack stack = super.getCloneItemStack(state, target, level, pos, player);
        CopyFluidFunction.copyToItem(stack, level.m_7702_(pos));
        return stack;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        for (Direction direction : context.m_6232_()) {
            if (direction.m_122434_() != Direction.Axis.Y) continue;
            BlockState state = (BlockState)this.m_49966_().m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(direction == Direction.UP));
            return state.m_60710_((LevelReader)context.m_43725_(), context.m_8083_()) ? state : null;
        }
        return null;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)HANGING) != false ? HANGING_SHAPE : SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{HANGING, LIT}));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = LampBlock.getConnectedDirection(state).m_122424_();
        return Block.m_49863_((LevelReader)level, (BlockPos)pos.m_121945_(direction), (Direction)direction.m_122424_());
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return LampBlock.getConnectedDirection(state).m_122424_() == facing && !state.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        BlockPos blockpos = hit.m_82425_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (projectile.m_142265_(level, blockpos) && Helpers.isEntity((Entity)projectile, EntityTypeTags.f_13124_)) {
                serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50058_.m_49966_()), projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), 10, 0.0, 0.0, 0.0, (double)0.15f);
                level.m_46953_(blockpos, true, (Entity)projectile);
                if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                    projectile.m_20254_(5);
                    Direction fireDir = Direction.Plane.HORIZONTAL.m_235690_(level.f_46441_);
                    BlockPos pos = projectile.m_20183_();
                    if (FireBlock.m_49255_((Level)level, (BlockPos)pos, (Direction)fireDir)) {
                        level.m_46597_(pos, FireBlock.m_49245_((BlockGetter)level, (BlockPos)pos));
                    }
                }
            }
        }
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType path) {
        return false;
    }
}

