/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import java.util.function.BiPredicate;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.CharcoalForgeBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.CharcoalPileBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.blocks.devices.IBellowsConsumer;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.MultiBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CharcoalForgeBlock
extends DeviceBlock
implements IBellowsConsumer {
    public static final IntegerProperty HEAT = TFCBlockStateProperties.HEAT_LEVEL;
    private static final MultiBlock FORGE_MULTIBLOCK;

    public static boolean isValid(LevelAccessor level, BlockPos pos) {
        return FORGE_MULTIBLOCK.test(level, pos);
    }

    public static boolean isForgeInsulationBlock(BlockState state) {
        return Helpers.isBlock(state, TFCTags.Blocks.FORGE_INSULATION);
    }

    public CharcoalForgeBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)HEAT, (Comparable)Integer.valueOf(0)));
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        int i;
        if ((Integer)state.m_61143_((Property)HEAT) == 0) {
            return;
        }
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 0.875;
        double z = (double)pos.m_123343_() + 0.5;
        if (rand.m_188503_(10) == 0) {
            level.m_7785_(x, y, z, SoundEvents.f_11936_, SoundSource.BLOCKS, 0.5f + rand.m_188501_(), rand.m_188501_() * 0.7f + 0.6f, false);
        }
        for (i = 0; i < 1 + rand.m_188503_(2); ++i) {
            level.m_7107_((ParticleOptions)ParticleTypes.f_123755_, x + (double)Helpers.triangle(rand), y + rand.m_188500_(), z + (double)Helpers.triangle(rand), 0.0, 0.07, 0.0);
        }
        for (i = 0; i < rand.m_188503_(3); ++i) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + (double)Helpers.triangle(rand), y + rand.m_188500_(), z + (double)Helpers.triangle(rand), 0.0, 0.005, 0.0);
        }
        if (rand.m_188503_(8) == 1) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123756_, x + (double)Helpers.triangle(rand), y + rand.m_188500_(), z + (double)Helpers.triangle(rand), 0.0, 0.005, 0.0);
        }
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (!entity.m_5825_() && entity instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)((LivingEntity)entity)) && (Integer)level.m_8055_(pos).m_61143_((Property)HEAT) > 0) {
            entity.m_6469_(entity.m_269291_().m_269047_(), 1.0f);
        }
        super.m_141947_(level, pos, state, entity);
    }

    @Override
    public void intakeAir(Level level, BlockPos pos, BlockState state, int amount) {
        level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.CHARCOAL_FORGE.get()).ifPresent(forge -> forge.intakeAir(amount));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{HEAT}));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        return (Integer)state.m_61143_((Property)HEAT) > 0 && !CharcoalForgeBlock.isValid(world, currentPos) ? (BlockState)state.m_61124_((Property)HEAT, (Comparable)Integer.valueOf(0)) : state;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        CharcoalForgeBlockEntity forge = level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.CHARCOAL_FORGE.get()).orElse(null);
        if (forge != null) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Helpers.openScreen(serverPlayer, (MenuProvider)forge, pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return CharcoalPileBlock.SHAPE_BY_LAYER[7];
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if ((Integer)state.m_61143_((Property)HEAT) > 0) {
            if (CharcoalForgeBlock.isValid((LevelAccessor)level, pos)) {
                Helpers.fireSpreaderTick(level, pos.m_7494_(), rand, 3);
            } else {
                level.m_46597_(pos, (BlockState)this.m_49966_().m_61124_((Property)HEAT, (Comparable)Integer.valueOf(0)));
            }
        }
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    static {
        BiPredicate<LevelAccessor, BlockPos> skyMatcher = BlockAndTintGetter::m_45527_;
        BiPredicate<LevelAccessor, BlockPos> isValidSide = (level, pos) -> CharcoalForgeBlock.isForgeInsulationBlock(level.m_8055_(pos));
        BlockPos origin = BlockPos.f_121853_;
        FORGE_MULTIBLOCK = new MultiBlock().match(origin.m_7494_(), state -> state.m_60795_() || Helpers.isBlock(state, TFCTags.Blocks.FORGE_INVISIBLE_WHITELIST)).matchOneOf(origin.m_7494_(), new MultiBlock().match(origin, skyMatcher).matchHorizontal(origin, skyMatcher, 1).matchHorizontal(origin, skyMatcher, 2)).matchEachDirection(origin, isValidSide, new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.DOWN}, 1);
    }
}

