/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import net.dries007.tfc.common.blockentities.BellowsBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BellowsBlock
extends DeviceBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final VoxelShape[] COMPLETE_SHAPES = Helpers.computeHorizontalShapes(d -> BellowsBlock.createShapeFor(d, 0.875f));
    private final ExtendedProperties properties;

    private static VoxelShape createShapeFor(Direction direction, float extension) {
        return Shapes.m_83124_((VoxelShape)BellowsBlock.makeFrontShape(direction), (VoxelShape[])new VoxelShape[]{BellowsBlock.makeMiddleShape(direction, extension), BellowsBlock.makeEndShape(direction, extension)});
    }

    private static VoxelShape makeFrontShape(Direction direction) {
        return Helpers.rotateShape(direction, 0.0, 0.0, 0.0, 16.0, 16.0, 2.0);
    }

    private static VoxelShape makeMiddleShape(Direction direction, float extension) {
        return Helpers.rotateShape(direction, 2.0, 2.0, 2.0, 14.0, 14.0, extension * 16.0f);
    }

    private static VoxelShape makeEndShape(Direction direction, float extension) {
        return Helpers.rotateShape(direction, 0.0, 0.0, extension * 16.0f, 16.0, 16.0, extension * 16.0f + 2.0f);
    }

    public BellowsBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.NOOP);
        this.properties = properties;
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.BELLOWS.get()).map(bellows -> {
            float ext = 1.0f - bellows.getExtensionLength(1.0f);
            return ext == 0.875f ? COMPLETE_SHAPES[direction.m_122416_()] : BellowsBlock.createShapeFor(direction, ext);
        }).orElse(COMPLETE_SHAPES[direction.m_122416_()]);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        state.m_60701_((LevelAccessor)level, pos, 3);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_();
        boolean isShifting = context.m_43723_() != null && context.m_43723_().m_6144_();
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)(isShifting ? direction : direction.m_122424_()));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        level.m_186460_(pos, (Block)this, 2);
        return level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.BELLOWS.get()).map(BellowsBlockEntity::onRightClick).orElse(InteractionResult.PASS);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

