/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import java.util.List;
import net.dries007.tfc.common.blockentities.BarrelBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.BarrelRackBlock;
import net.dries007.tfc.common.blocks.devices.SealableDeviceBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Tooltips;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class BarrelBlock
extends SealableDeviceBlock {
    public static final VoxelShape SHAPE_Z = BarrelBlock.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)12.0, (double)16.0);
    public static final VoxelShape SHAPE_X = BarrelBlock.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)12.0, (double)14.0);
    public static final VoxelShape RACK_SHAPE = Shapes.m_83124_((VoxelShape)BarrelBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0), (VoxelShape[])new VoxelShape[]{BarrelBlock.m_49796_((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), BarrelBlock.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), BarrelBlock.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)16.0, (double)16.0), BarrelBlock.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    public static final VoxelShape SHAPE_Z_RACK = Shapes.m_83110_((VoxelShape)SHAPE_Z, (VoxelShape)RACK_SHAPE);
    public static final VoxelShape SHAPE_X_RACK = Shapes.m_83110_((VoxelShape)SHAPE_X, (VoxelShape)RACK_SHAPE);
    public static final EnumProperty<Direction> FACING = TFCBlockStateProperties.FACING_NOT_DOWN;
    public static final BooleanProperty RACK = TFCBlockStateProperties.RACK;
    private static final int[] IMAGE_TOOLTIP = new int[]{1, 1, 2, 2};

    public static void toggleSeal(Level level, BlockPos pos, BlockState state) {
        level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.BARREL.get()).ifPresent(barrel -> {
            boolean previousSealed = (Boolean)state.m_61143_((Property)SEALED);
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)SEALED, (Comparable)Boolean.valueOf(!previousSealed)));
            if (previousSealed) {
                barrel.onUnseal();
            } else {
                barrel.onSeal();
            }
        });
    }

    public BarrelBlock(ExtendedProperties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)SEALED, (Comparable)Boolean.valueOf(false))).m_61124_(FACING, (Comparable)Direction.UP)).m_61124_((Property)RACK, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BarrelBlockEntity barrel = level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.BARREL.get()).orElse(null);
        if (barrel != null) {
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_41619_() && player.m_6144_()) {
                if (((Boolean)state.m_61143_((Property)RACK)).booleanValue() && level.m_8055_(pos.m_7494_()).m_60795_() && hit.m_82450_().f_82480_ - (double)pos.m_123342_() > 0.875) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)((Block)TFCBlocks.BARREL_RACK.get()).m_5456_()));
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)RACK, (Comparable)Boolean.valueOf(false)));
                } else {
                    BarrelBlock.toggleSeal(level, pos, state);
                }
                level.m_5594_(null, pos, SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, 0.85f);
                return InteractionResult.SUCCESS;
            }
            if (Helpers.isItem(stack, ((Block)TFCBlocks.BARREL_RACK.get()).m_5456_()) && state.m_61143_(FACING) != Direction.UP && !((Boolean)state.m_61143_((Property)RACK)).booleanValue()) {
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                level.m_46597_(pos, (BlockState)((BlockState)state.m_61124_((Property)RACK, (Comparable)Boolean.valueOf(true))).m_61124_(FACING, (Comparable)player.m_6350_().m_122424_()));
                Helpers.playPlaceSound((LevelAccessor)level, pos, state);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (FluidHelpers.transferBetweenBlockEntityAndItem(stack, barrel, player, hand)) {
                return InteractionResult.SUCCESS;
            }
            if (!level.m_5776_() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Helpers.openScreen(serverPlayer, (MenuProvider)barrel, barrel.m_58899_());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6256_(BlockState state, Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity;
        if (((Boolean)state.m_61143_((Property)SEALED)).booleanValue() && (blockEntity = level.m_7702_(pos)) instanceof BarrelBlockEntity) {
            IFluidHandler tank;
            BarrelBlockEntity barrel = (BarrelBlockEntity)blockEntity;
            if (Helpers.isItem(player.m_21205_(), (TagKey<Item>)Tags.Items.RODS_WOODEN) && (tank = Helpers.getCapability((ICapabilityProvider)barrel, Capabilities.FLUID)) != null) {
                float fill = (float)tank.getFluidInTank(0).getAmount() / (float)tank.getTankCapacity(0);
                int note = Mth.m_14167_((float)(fill * 24.0f));
                level.m_262808_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (Holder)SoundEvents.f_12208_, SoundSource.RECORDS, 3.0f, NoteBlock.m_276981_((int)note), level.f_46441_.m_188505_());
            }
        }
    }

    @Override
    protected void addExtraInfo(List<Component> tooltip, CompoundTag inventoryTag) {
        FluidTank tank = new FluidTank(((Integer)TFCConfig.SERVER.barrelCapacity.get()).intValue());
        tank.readFromNBT(inventoryTag.m_128469_("tank"));
        if (!tank.isEmpty()) {
            tooltip.add((Component)Tooltips.fluidUnitsOf(tank.getFluid()));
        }
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (((Direction)state.m_61143_(FACING)).m_122434_().m_122479_() && facing == Direction.DOWN && !level.m_8055_(facingPos).m_60659_((BlockGetter)level, facingPos, Direction.UP, SupportType.CENTER)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    @Override
    public int[] getImageTooltipParameters() {
        return IMAGE_TOOLTIP;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        if (state != null) {
            BlockPos pos;
            Direction dir = context.m_43719_();
            if (dir == Direction.DOWN) {
                dir = Direction.UP;
            }
            state = (BlockState)state.m_61124_(FACING, (Comparable)dir);
            Level level = context.m_43725_();
            if (Helpers.isBlock(level.m_8055_(pos = context.m_8083_()), (Block)TFCBlocks.BARREL_RACK.get())) {
                return (BlockState)((BlockState)state.m_61124_(FACING, (Comparable)context.m_8125_())).m_61124_((Property)RACK, (Comparable)Boolean.valueOf(true));
            }
            if (!level.m_8055_(pos.m_7495_()).m_60659_((BlockGetter)level, pos.m_7495_(), Direction.UP, SupportType.CENTER)) {
                return null;
            }
        }
        return state;
    }

    public BlockState rotate(BlockState state, LevelAccessor level, BlockPos pos, Rotation direction) {
        return (BlockState)state.m_61124_(FACING, (Comparable)direction.m_55954_((Direction)state.m_61143_(FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_(FACING)));
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        boolean rack = (Boolean)state.m_61143_((Property)RACK);
        return switch (((Direction)state.m_61143_(FACING)).m_122434_()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> {
                if (rack) {
                    yield SHAPE_X_RACK;
                }
                yield SHAPE_X;
            }
            case Direction.Axis.Z -> {
                if (rack) {
                    yield SHAPE_Z_RACK;
                }
                yield SHAPE_Z;
            }
            case Direction.Axis.Y -> super.m_5940_(state, level, pos, context);
        };
    }

    @Override
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!Helpers.isBlock(state, newState.m_60734_()) && ((Boolean)state.m_61143_((Property)RACK)).booleanValue() && !(newState.m_60734_() instanceof BarrelRackBlock)) {
            Helpers.spawnItem(level, pos, new ItemStack((ItemLike)TFCBlocks.BARREL_RACK.get()));
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{FACING, RACK}));
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (((Boolean)state.m_61143_((Property)RACK)).booleanValue()) {
            this.m_5707_(level, pos, state, player);
            return level.m_7731_(pos, ((Block)TFCBlocks.BARREL_RACK.get()).m_49966_(), level.f_46443_ ? 11 : 3);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity;
        if (((Boolean)TFCConfig.SERVER.barrelEnableRedstoneSeal.get()).booleanValue() && (blockEntity = level.m_7702_(pos)) instanceof BarrelBlockEntity) {
            BarrelBlockEntity barrel = (BarrelBlockEntity)blockEntity;
            this.handleNeighborChanged(state, level, pos, barrel::onSeal, barrel::onUnseal);
        }
    }
}

