/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.crop;

import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.CropBlockEntity;
import net.dries007.tfc.common.blockentities.FarmlandBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.crop.Crop;
import net.dries007.tfc.common.blocks.crop.DefaultCropBlock;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.climate.ClimateRange;
import net.dries007.tfc.util.climate.ClimateRanges;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public abstract class PickableCropBlock
extends DefaultCropBlock {
    @Nullable
    private final Supplier<Supplier<? extends Item>> fruit;
    private final Supplier<Supplier<? extends Item>> matureFruit;

    public static PickableCropBlock create(ExtendedProperties properties, int stages, Crop crop, @Nullable Supplier<Supplier<? extends Item>> fruit, Supplier<Supplier<? extends Item>> matureFruit) {
        final IntegerProperty property = TFCBlockStateProperties.getAgeProperty(stages - 1);
        return new PickableCropBlock(properties, stages - 1, (Supplier)TFCBlocks.DEAD_CROPS.get((Object)crop), (Supplier)TFCItems.CROP_SEEDS.get((Object)crop), crop.getPrimaryNutrient(), ClimateRanges.CROPS.get((Object)crop), fruit, matureFruit){

            @Override
            public IntegerProperty m_7959_() {
                return property;
            }
        };
    }

    protected PickableCropBlock(ExtendedProperties properties, int maxAge, Supplier<? extends Block> dead, Supplier<? extends Item> seeds, FarmlandBlockEntity.NutrientType primaryNutrient, Supplier<ClimateRange> climateRange, @Nullable Supplier<Supplier<? extends Item>> fruit, Supplier<Supplier<? extends Item>> matureFruit) {
        super(properties, maxAge, dead, seeds, primaryNutrient, climateRange);
        this.fruit = fruit;
        this.matureFruit = matureFruit;
    }

    @Nullable
    public Item getFirstFruit() {
        return this.fruit == null ? null : this.fruit.get().get();
    }

    public Item getSecondFruit() {
        return this.matureFruit.get().get();
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        InteractionResult res = super.m_6227_(state, level, pos, player, hand, result);
        if (res.m_19077_()) {
            return res;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CropBlockEntity) {
            CropBlockEntity crop = (CropBlockEntity)blockEntity;
            float yield = crop.getYield();
            int age = (Integer)state.m_61143_((Property)this.m_7959_());
            RandomSource random = level.m_213780_();
            if (age == this.maxAge - 1 && this.getFirstFruit() != null) {
                crop.setGrowth(Mth.m_216267_((RandomSource)random, (float)0.4f, (float)0.5f));
                crop.setYield(0.0f);
                this.postGrowthTick(level, pos, state, crop);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.yieldItemStack(this.getFirstFruit(), yield, random));
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (age == this.maxAge) {
                crop.setGrowth(Mth.m_216267_((RandomSource)random, (float)0.5f, (float)0.6f));
                crop.setYield(0.0f);
                this.postGrowthTick(level, pos, state, crop);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.yieldItemStack(this.getSecondFruit(), yield, random));
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    private ItemStack yieldItemStack(Item item, float yield, RandomSource random) {
        return new ItemStack((ItemLike)item, Mth.m_14143_((float)(Mth.m_14179_((float)yield, (float)1.0f, (float)5.0f) + (float)random.m_188503_(2))));
    }
}

