/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.crop;

import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.CropBlockEntity;
import net.dries007.tfc.common.blockentities.FarmlandBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.crop.Crop;
import net.dries007.tfc.common.blocks.crop.CropBlock;
import net.dries007.tfc.common.blocks.crop.DeadCropBlock;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.climate.ClimateRange;
import net.dries007.tfc.util.climate.ClimateRanges;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class DefaultCropBlock
extends CropBlock {
    public static DefaultCropBlock create(ExtendedProperties properties, int stages, Crop crop) {
        final IntegerProperty property = TFCBlockStateProperties.getAgeProperty(stages - 1);
        return new DefaultCropBlock(properties, stages - 1, (Supplier)TFCBlocks.DEAD_CROPS.get((Object)crop), (Supplier)TFCItems.CROP_SEEDS.get((Object)crop), crop.getPrimaryNutrient(), ClimateRanges.CROPS.get((Object)crop)){

            @Override
            public IntegerProperty m_7959_() {
                return property;
            }
        };
    }

    protected DefaultCropBlock(ExtendedProperties properties, int maxAge, Supplier<? extends Block> dead, Supplier<? extends Item> seeds, FarmlandBlockEntity.NutrientType primaryNutrient, Supplier<ClimateRange> climateRange) {
        super(properties, maxAge, dead, seeds, primaryNutrient, climateRange);
    }

    @Override
    public void die(Level level, BlockPos pos, BlockState state, boolean fullyGrown) {
        BlockState deadState = (BlockState)((Block)this.dead.get()).m_49966_().m_61124_((Property)DeadCropBlock.MATURE, (Comparable)Boolean.valueOf(fullyGrown));
        level.m_46597_(pos, deadState);
    }

    @Override
    protected void postGrowthTick(Level level, BlockPos pos, BlockState state, CropBlockEntity crop) {
        int age = crop.getGrowth() == 1.0f ? this.m_7419_() : (int)(crop.getGrowth() * (float)this.m_7419_());
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(age)));
    }
}

