/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.crop;

import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.blockentities.CropBlockEntity;
import net.dries007.tfc.common.blockentities.FarmlandBlockEntity;
import net.dries007.tfc.common.blockentities.IFarmland;
import net.dries007.tfc.common.blocks.crop.ICropBlock;
import net.dries007.tfc.common.blocks.soil.FarmlandBlock;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Fertilizer;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.advancements.TFCAdvancements;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendar;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.climate.ClimateRange;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public final class CropHelpers {
    public static final long UPDATE_INTERVAL = 48000L;
    public static final float GROWTH_FACTOR = 1.7361111E-6f;
    public static final float NUTRIENT_CONSUMPTION = 3.4722223E-6f;
    public static final float NUTRIENT_GROWTH_FACTOR = 0.5f;
    public static final float GROWTH_LIMIT = 1.0f;
    public static final float EXPIRY_LIMIT = 2.0f;
    public static final float YIELD_MIN = 0.2f;
    public static final float YIELD_LIMIT = 1.0f;

    public static boolean lightValid(Level level, BlockPos pos) {
        return level.m_45524_(pos, 0) >= 12;
    }

    public static boolean growthTick(Level level, BlockPos pos, BlockState state, CropBlockEntity crop) {
        long firstTick = crop.getLastGrowthTick();
        long thisTick = Calendars.SERVER.getTicks();
        long lastTick = firstTick;
        for (long tick = firstTick + 48000L; tick < thisTick; tick += 48000L) {
            if (!CropHelpers.growthTickStep(level, pos, state, level.m_213780_(), lastTick, tick, crop)) {
                return false;
            }
            lastTick = tick;
        }
        return lastTick >= thisTick || CropHelpers.growthTickStep(level, pos, state, level.m_213780_(), lastTick, thisTick, crop);
    }

    public static boolean growthTickStep(Level level, BlockPos pos, BlockState state, RandomSource random, long fromTick, long toTick, CropBlockEntity crop) {
        float growthDelta;
        float delta;
        ICalendar calendar = Calendars.get((LevelReader)level);
        BlockPos sourcePos = pos.m_7495_();
        int hydration = FarmlandBlock.getHydration((LevelAccessor)level, sourcePos);
        float startTemperature = Climate.getTemperature(level, pos, calendar, Calendars.SERVER.ticksToCalendarTicks(fromTick));
        float endTemperature = Climate.getTemperature(level, pos, calendar, Calendars.SERVER.ticksToCalendarTicks(toTick));
        long tickDelta = toTick - fromTick;
        ICropBlock cropBlock = (ICropBlock)state.m_60734_();
        ClimateRange range = cropBlock.getClimateRange();
        boolean growing = CropHelpers.checkClimate(range, hydration, startTemperature, endTemperature, false);
        boolean healthy = growing || CropHelpers.checkClimate(range, hydration, startTemperature, endTemperature, true);
        FarmlandBlockEntity.NutrientType primaryNutrient = cropBlock.getPrimaryNutrient();
        float nutrientsAvailable = 0.0f;
        float nutrientsRequired = 3.4722223E-6f * (float)tickDelta;
        float nutrientsConsumed = 0.0f;
        BlockEntity blockEntity = level.m_7702_(sourcePos);
        if (blockEntity instanceof IFarmland) {
            IFarmland farmland = (IFarmland)blockEntity;
            nutrientsAvailable = farmland.getNutrient(primaryNutrient);
            nutrientsConsumed = farmland.consumeNutrientAndResupplyOthers(primaryNutrient, nutrientsRequired);
        }
        float growthModifier = ((Double)TFCConfig.SERVER.cropGrowthModifier.get()).floatValue();
        float expiryModifier = ((Double)TFCConfig.SERVER.cropExpiryModifier.get()).floatValue();
        float localExpiryLimit = 2.0f * expiryModifier * (1.0f / growthModifier);
        float totalGrowthDelta = 1.0f / growthModifier * Helpers.uniform(random, 0.9f, 1.1f) * (float)tickDelta * 1.7361111E-6f + nutrientsConsumed * 0.5f;
        float initialGrowth = crop.getGrowth();
        float remainingGrowthDelta = totalGrowthDelta;
        float growth = initialGrowth;
        float expiry = crop.getExpiry();
        float actualYield = crop.getYield();
        expiry *= localExpiryLimit / 2.0f;
        float growthLimit = cropBlock.getGrowthLimit(level, pos, state);
        if (remainingGrowthDelta > 0.0f && growing && growth < growthLimit) {
            delta = Math.min(remainingGrowthDelta, growthLimit - growth);
            growth += delta;
            remainingGrowthDelta -= delta;
        }
        if (remainingGrowthDelta > 0.0f) {
            delta = Math.min(remainingGrowthDelta, localExpiryLimit - expiry);
            expiry += delta;
        }
        float nutrientSatisfaction = (growthDelta = growth - initialGrowth) <= 0.0f || nutrientsRequired <= 0.0f ? 1.0f : Math.min(1.0f, totalGrowthDelta / growthDelta * (nutrientsAvailable / nutrientsRequired));
        actualYield += growthDelta * Helpers.lerp(nutrientSatisfaction, 0.2f, 1.0f);
        if (expiry >= localExpiryLimit || !healthy) {
            cropBlock.die(level, pos, state, growth >= 1.0f);
            return false;
        }
        crop.setGrowth(growth);
        crop.setYield(actualYield);
        crop.setExpiry(expiry *= 2.0f / localExpiryLimit);
        crop.setLastGrowthTick(calendar.getTicks());
        return true;
    }

    private static boolean checkClimate(ClimateRange range, int hydration, float firstTemperature, float secondTemperature, boolean allowWiggle) {
        return range.checkBoth(hydration, firstTemperature, allowWiggle) && range.checkTemperature(secondTemperature, allowWiggle) == ClimateRange.Result.VALID;
    }

    public static boolean useFertilizer(Level level, Player player, InteractionHand hand, BlockPos farmlandPos) {
        BlockEntity blockEntity;
        ItemStack stack = player.m_21120_(hand);
        Fertilizer fertilizer = Fertilizer.get(stack);
        if (fertilizer != null && (blockEntity = level.m_7702_(farmlandPos)) instanceof IFarmland) {
            IFarmland farmland = (IFarmland)blockEntity;
            if (!level.m_5776_()) {
                int repeat = -1;
                if (player.m_6144_()) {
                    repeat = CropHelpers.minAmountRequiredToNextFillBar(farmland, fertilizer, FarmlandBlockEntity.NutrientType.NITROGEN, repeat);
                    repeat = CropHelpers.minAmountRequiredToNextFillBar(farmland, fertilizer, FarmlandBlockEntity.NutrientType.POTASSIUM, repeat);
                    repeat = CropHelpers.minAmountRequiredToNextFillBar(farmland, fertilizer, FarmlandBlockEntity.NutrientType.PHOSPHOROUS, repeat);
                    repeat = Math.min(repeat, stack.m_41613_());
                }
                if (repeat == -1) {
                    repeat = 1;
                }
                if (!(fertilizer.getNitrogen() != 0.0f && farmland.getNutrient(FarmlandBlockEntity.NutrientType.NITROGEN) != 1.0f || fertilizer.getPotassium() != 0.0f && farmland.getNutrient(FarmlandBlockEntity.NutrientType.POTASSIUM) != 1.0f || fertilizer.getPhosphorus() != 0.0f && farmland.getNutrient(FarmlandBlockEntity.NutrientType.PHOSPHOROUS) != 1.0f)) {
                    return false;
                }
                farmland.addNutrients(fertilizer, repeat);
                if (!player.m_7500_()) {
                    stack.m_41774_(repeat);
                }
                IFarmland.addNutrientParticles((ServerLevel)level, farmlandPos.m_7494_(), fertilizer);
                Helpers.playSound(level, farmlandPos, (SoundEvent)TFCSounds.FERTILIZER_USE.get());
                if (farmland.isMaxedOut() && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    TFCAdvancements.FULL_FERTILIZER.trigger(serverPlayer);
                }
            }
            return true;
        }
        return false;
    }

    private static int minAmountRequiredToNextFillBar(IFarmland farmland, Fertilizer fertilizer, FarmlandBlockEntity.NutrientType type, int prevValue) {
        if (fertilizer.getNutrient(type) > 0.0f && farmland.getNutrient(type) < 1.0f) {
            int requiredValue = Mth.m_14167_((float)((1.0f - farmland.getNutrient(type)) / fertilizer.getNutrient(type)));
            if (prevValue == -1 || requiredValue < prevValue) {
                return requiredValue;
            }
        }
        return prevValue;
    }
}

