/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import java.util.Arrays;
import net.dries007.tfc.client.IGhostBlockHandler;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.blocks.ExtendedBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class StainedWattleBlock
extends ExtendedBlock
implements IGhostBlockHandler {
    public static final BooleanProperty TOP = TFCBlockStateProperties.TOP;
    public static final BooleanProperty BOTTOM = TFCBlockStateProperties.BOTTOM;
    public static final BooleanProperty LEFT = TFCBlockStateProperties.LEFT;
    public static final BooleanProperty RIGHT = TFCBlockStateProperties.RIGHT;
    private static final double TOP_LIMIT = 0.75;
    private static final double BOTTOM_LIMIT = 0.25;
    private static final double MIDDLE = 0.5;

    @Nullable
    private static BlockState getStateFor(BlockState state, Direction lookDirection, double x, double y, double z) {
        double horizontal;
        if (lookDirection.m_122434_() == Direction.Axis.Y) {
            return null;
        }
        double d = horizontal = lookDirection.m_122434_() == Direction.Axis.Z ? x : z;
        if (y > 0.75 && !((Boolean)state.m_61143_((Property)TOP)).booleanValue()) {
            return (BlockState)state.m_61124_((Property)TOP, (Comparable)Boolean.valueOf(true));
        }
        if (y < 0.25 && !((Boolean)state.m_61143_((Property)BOTTOM)).booleanValue()) {
            return (BlockState)state.m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(true));
        }
        if (horizontal < 0.5 && !((Boolean)state.m_61143_((Property)LEFT)).booleanValue()) {
            return (BlockState)state.m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(true));
        }
        if (horizontal > 0.5 && !((Boolean)state.m_61143_((Property)RIGHT)).booleanValue()) {
            return (BlockState)state.m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(true));
        }
        return null;
    }

    @Nullable
    private static BlockState removeStateFor(BlockState state, Direction lookDirection, double x, double y, double z) {
        double horizontal;
        if (lookDirection.m_122434_() == Direction.Axis.Y) {
            return null;
        }
        double d = horizontal = lookDirection.m_122434_() == Direction.Axis.Z ? x : z;
        if (y > 0.75 && ((Boolean)state.m_61143_((Property)TOP)).booleanValue()) {
            return (BlockState)state.m_61124_((Property)TOP, (Comparable)Boolean.valueOf(false));
        }
        if (y < 0.25 && ((Boolean)state.m_61143_((Property)BOTTOM)).booleanValue()) {
            return (BlockState)state.m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(false));
        }
        if (horizontal < 0.5 && ((Boolean)state.m_61143_((Property)LEFT)).booleanValue()) {
            return (BlockState)state.m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(false));
        }
        if (horizontal > 0.5 && ((Boolean)state.m_61143_((Property)RIGHT)).booleanValue()) {
            return (BlockState)state.m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(false));
        }
        return null;
    }

    @Nullable
    private static BlockState getPossibleDyedState(ItemStack item, BlockState current) {
        BlockState found = Arrays.stream(Helpers.DYE_COLORS).filter(color -> Helpers.isItem(item, (Item)DyeItem.m_41082_((DyeColor)color))).map(color -> ((Block)TFCBlocks.STAINED_WATTLE.get(color).get()).m_49966_()).findFirst().orElse(null);
        return found != null && found.m_60734_() != current.m_60734_() ? found : null;
    }

    public StainedWattleBlock(ExtendedProperties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)TOP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResult.PASS;
        }
        ItemStack item = player.m_21120_(hand);
        if (item.m_41619_() && player.m_6144_()) {
            return this.tryTakeStick(state, level, pos, player, item, hit);
        }
        if (Helpers.isItem(item, (TagKey<Item>)Tags.Items.RODS_WOODEN)) {
            return this.tryAddStick(state, level, pos, player, item, hit);
        }
        if (Helpers.isBlock(state, (Block)TFCBlocks.WATTLE.get())) {
            return InteractionResult.PASS;
        }
        BlockState dyed = StainedWattleBlock.getPossibleDyedState(item, state);
        if (dyed != null) {
            if (level.f_46443_) {
                for (int i = 0; i < 5; ++i) {
                    Vec3 loc = hit.m_82450_();
                    level.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, item), loc.f_82479_, loc.f_82480_, loc.f_82481_, (double)(Helpers.triangle(level.f_46441_) / 3.0f), (double)(Helpers.triangle(level.f_46441_) / 3.0f), (double)(Helpers.triangle(level.f_46441_) / 3.0f));
                }
            }
            Helpers.playSound(level, pos, (SoundEvent)TFCSounds.WATTLE_DYED.get());
            dyed = (BlockState)((BlockState)((BlockState)((BlockState)dyed.m_61124_((Property)BOTTOM, (Comparable)((Boolean)state.m_61143_((Property)BOTTOM)))).m_61124_((Property)TOP, (Comparable)((Boolean)state.m_61143_((Property)TOP)))).m_61124_((Property)LEFT, (Comparable)((Boolean)state.m_61143_((Property)LEFT)))).m_61124_((Property)RIGHT, (Comparable)((Boolean)state.m_61143_((Property)RIGHT)));
            return this.setState(level, pos, dyed, player, item, 1);
        }
        return InteractionResult.PASS;
    }

    @Override
    @Nullable
    public BlockState getStateToDraw(Level level, Player player, BlockState state, Direction direction, BlockPos pos, double x, double y, double z, ItemStack item) {
        if (item.m_41619_() && player.m_6144_()) {
            return StainedWattleBlock.removeStateFor(state, direction, x, y, z);
        }
        if (Helpers.isItem(item, (TagKey<Item>)Tags.Items.RODS_WOODEN)) {
            return StainedWattleBlock.getStateFor(state, direction, x, y, z);
        }
        if (Helpers.isBlock(state, (Block)TFCBlocks.WATTLE.get())) {
            return null;
        }
        BlockState dyed = StainedWattleBlock.getPossibleDyedState(item, state);
        if (dyed != null) {
            return (BlockState)((BlockState)((BlockState)((BlockState)dyed.m_61124_((Property)BOTTOM, (Comparable)((Boolean)state.m_61143_((Property)BOTTOM)))).m_61124_((Property)TOP, (Comparable)((Boolean)state.m_61143_((Property)TOP)))).m_61124_((Property)LEFT, (Comparable)((Boolean)state.m_61143_((Property)LEFT)))).m_61124_((Property)RIGHT, (Comparable)((Boolean)state.m_61143_((Property)RIGHT)));
        }
        return null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{TOP, BOTTOM, LEFT, RIGHT}));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return this.m_7898_(state, (LevelReader)level, currentPos) ? state : Blocks.f_50016_.m_49966_();
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return !level.m_8055_(pos.m_7495_()).m_247087_();
    }

    protected InteractionResult tryAddStick(BlockState state, Level level, BlockPos pos, Player player, ItemStack item, BlockHitResult hit) {
        Vec3 location = hit.m_82450_();
        BlockState placeState = StainedWattleBlock.getStateFor(state, hit.m_82434_(), location.f_82479_ - (double)pos.m_123341_(), location.f_82480_ - (double)pos.m_123342_(), location.f_82481_ - (double)pos.m_123343_());
        if (placeState != null) {
            Helpers.playSound(level, pos, (SoundEvent)TFCSounds.WATTLE_WOVEN.get());
            return this.setState(level, pos, placeState, player, item, 1);
        }
        return InteractionResult.FAIL;
    }

    protected InteractionResult tryTakeStick(BlockState state, Level level, BlockPos pos, Player player, ItemStack item, BlockHitResult hit) {
        Vec3 location = hit.m_82450_();
        BlockState placeState = StainedWattleBlock.removeStateFor(state, hit.m_82434_(), location.f_82479_ - (double)pos.m_123341_(), location.f_82480_ - (double)pos.m_123342_(), location.f_82481_ - (double)pos.m_123343_());
        if (placeState != null) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)Items.f_42398_.m_7968_());
            Helpers.playSound(level, pos, (SoundEvent)TFCSounds.WATTLE_WOVEN.get());
            return this.setState(level, pos, placeState, player, item, 0);
        }
        return InteractionResult.PASS;
    }

    protected InteractionResult setState(Level level, BlockPos pos, BlockState state, Player player, ItemStack item, int toShrink) {
        if (!player.m_7500_()) {
            item.m_41774_(toShrink);
        }
        level.m_46597_(pos, state);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }
}

