/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import java.util.Optional;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.PileBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.Climate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class SnowPileBlock
extends SnowLayerBlock
implements IForgeBlockExtension,
EntityBlockExtension {
    private final ExtendedProperties properties;

    public static boolean canPlaceSnowPile(LevelAccessor level, BlockPos pos, BlockState state) {
        return Helpers.isBlock(state.m_60734_(), TFCTags.Blocks.CAN_BE_SNOW_PILED) && ((SnowPileBlock)TFCBlocks.SNOW_PILE.get()).m_49966_().m_60710_((LevelReader)level, pos);
    }

    public static void placeSnowPile(LevelAccessor level, BlockPos pos, BlockState state, boolean byPlayer) {
        BlockPos posAbove = pos.m_7494_();
        BlockState aboveState = level.m_8055_(posAbove);
        BlockState savedAboveState = Helpers.isBlock(aboveState.m_60734_(), TFCTags.Blocks.CAN_BE_SNOW_PILED) ? aboveState : null;
        BlockState snowPile = ((SnowPileBlock)TFCBlocks.SNOW_PILE.get()).m_49966_();
        level.m_7731_(pos, snowPile, 18);
        level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.PILE.get()).ifPresent(entity -> entity.setHiddenStates(state, savedAboveState, byPlayer));
        if (savedAboveState != null) {
            Helpers.removeBlock(level, posAbove, 18);
        }
        level.m_6289_(pos, (Block)TFCBlocks.SNOW_PILE.get());
        if (savedAboveState != null) {
            level.m_6289_(posAbove, Blocks.f_50016_);
        }
        BlockPos posBelow = pos.m_7495_();
        level.m_7731_(posBelow, Helpers.setProperty(level.m_8055_(posBelow), SnowyDirtBlock.f_56637_, true), 2);
    }

    public static void removePileOrSnow(LevelAccessor level, BlockPos pos, BlockState state) {
        SnowPileBlock.removePileOrSnow(level, pos, state, -1);
    }

    public static void removePileOrSnow(LevelAccessor level, BlockPos pos, BlockState state, int expectedLayers) {
        SnowPileBlock.removePileOrSnow(level, pos, state, expectedLayers, null);
    }

    public static void removePileOrSnow(LevelAccessor level, BlockPos pos, BlockState state, int expectedLayers, @Nullable Optional<PileBlockEntity> snowPile) {
        int layers = (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_);
        if (expectedLayers >= layers) {
            return;
        }
        if (layers > 1 && expectedLayers != 0) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(expectedLayers == -1 ? layers - 1 : expectedLayers)), 3);
        } else if (state.m_60734_() == Blocks.f_50125_) {
            level.m_7471_(pos, false);
        } else {
            if (snowPile == null) {
                snowPile = level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.PILE.get());
            }
            snowPile.ifPresent(pile -> {
                BlockPos above = pos.m_7494_();
                level.m_7731_(pos, pile.getInternalState(), 18);
                if (pile.getAboveState() != null && level.m_46859_(above)) {
                    level.m_7731_(above, pile.getAboveState(), 18);
                }
                pile.getInternalState().m_60701_(level, pos, 2);
                level.m_8055_(above).m_60701_(level, above, 2);
                level.m_6289_(pos, pile.getInternalState().m_60734_());
                if (pile.getAboveState() != null) {
                    level.m_6289_(above, pile.getAboveState().m_60734_());
                }
            });
        }
    }

    public SnowPileBlock(ExtendedProperties properties) {
        super(properties.properties());
        this.properties = properties;
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity entity, ItemStack stack) {
        Optional<PileBlockEntity> optional;
        super.m_6240_(level, player, pos, state, entity, stack);
        if (entity instanceof PileBlockEntity) {
            PileBlockEntity pile = (PileBlockEntity)entity;
            optional = Optional.of(pile);
        } else {
            optional = Optional.empty();
        }
        SnowPileBlock.removePileOrSnow((LevelAccessor)level, pos, state, -1, optional);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        if (context.m_43722_().m_41720_() == Blocks.f_50125_.m_5456_() && (Integer)state.m_61143_((Property)f_56581_) < 8) {
            if (context.m_7058_()) {
                return context.m_43719_() == Direction.UP;
            }
            return true;
        }
        return false;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.m_49966_();
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.m_213780_().m_188503_(75) == 0 && Climate.getTemperature((Level)level, pos) > 2.0f || level.m_45517_(LightLayer.BLOCK, pos) > 11) {
            SnowPileBlock.removePileOrSnow((LevelAccessor)level, pos, state);
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)Blocks.f_50125_);
    }
}

