/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.BottomSupportedDeviceBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PouredGlassBlock
extends ExtendedBlock {
    public static final VoxelShape SHAPE = PouredGlassBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private final Supplier<? extends Item> drop;

    public static Item getStainedGlass(DyeColor color) {
        return switch (color) {
            case DyeColor.WHITE -> Items.f_42176_;
            case DyeColor.ORANGE -> Items.f_42177_;
            case DyeColor.MAGENTA -> Items.f_42178_;
            case DyeColor.LIGHT_BLUE -> Items.f_42179_;
            case DyeColor.YELLOW -> Items.f_42180_;
            case DyeColor.LIME -> Items.f_42181_;
            case DyeColor.PINK -> Items.f_42182_;
            case DyeColor.GRAY -> Items.f_42183_;
            case DyeColor.LIGHT_GRAY -> Items.f_42184_;
            case DyeColor.CYAN -> Items.f_42185_;
            case DyeColor.PURPLE -> Items.f_42186_;
            case DyeColor.BLUE -> Items.f_42187_;
            case DyeColor.BROWN -> Items.f_42188_;
            case DyeColor.GREEN -> Items.f_42189_;
            case DyeColor.RED -> Items.f_42190_;
            default -> Items.f_42191_;
        };
    }

    public PouredGlassBlock(ExtendedProperties properties, Supplier<? extends Item> drop) {
        super(properties);
        this.drop = drop;
    }

    public Item getDrop() {
        return this.drop.get();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return BottomSupportedDeviceBlock.canSurvive(level, pos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return BottomSupportedDeviceBlock.canSurvive((LevelReader)context.m_43725_(), context.m_8083_()) ? super.m_5573_(context) : null;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !facingState.m_60783_((BlockGetter)level, facingPos, Direction.UP) && !Helpers.isBlock(facingState, TFCTags.Blocks.BOTTOM_SUPPORT_ACCEPTED) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }
}

