/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities.rotation;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.blockentities.rotation.RotatingBlockEntity;
import net.dries007.tfc.common.blocks.rotation.AxleBlock;
import net.dries007.tfc.common.blocks.rotation.WindmillBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.rotation.NetworkAction;
import net.dries007.tfc.util.rotation.Node;
import net.dries007.tfc.util.rotation.Rotation;
import net.dries007.tfc.util.rotation.SourceNode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class WindmillBlockEntity
extends TickableInventoryBlockEntity<ItemStackHandler>
implements RotatingBlockEntity {
    public static final int SLOTS = 5;
    public static final float MIN_SPEED = 0.015707964f;
    public static final float MAX_SPEED = 0.03926991f;
    private static final float LERP_SPEED = 1.5707964E-4f;
    private static final Component NAME = Component.m_237115_((String)"tfc.block_entity.windmill");
    private final SourceNode node;
    private boolean invalid;
    private boolean needsStateUpdate = true;

    public static void serverTick(Level level, BlockPos pos, BlockState state, WindmillBlockEntity windmill) {
        windmill.checkForLastTickSync();
        if (windmill.needsStateUpdate) {
            windmill.updateState();
        }
        WindmillBlockEntity.clientTick(level, pos, state, windmill);
        if (level.m_46467_() % 40L == 0L && WindmillBlockEntity.isObstructedBySolidBlocks(level, pos, (Direction.Axis)state.m_61143_(WindmillBlock.AXIS))) {
            level.m_46961_(pos, true);
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, WindmillBlockEntity windmill) {
        Rotation.Tickable rotation = windmill.node.rotation();
        rotation.tick();
        float targetSpeed = Mth.m_184637_((float)((Integer)state.m_61143_((Property)WindmillBlock.COUNT)).intValue(), (float)1.0f, (float)5.0f, (float)0.015707964f, (float)0.03926991f);
        float currentSpeed = rotation.speed();
        float nextSpeed = targetSpeed > currentSpeed ? Math.min(targetSpeed, currentSpeed + 1.5707964E-4f) : Math.max(targetSpeed, currentSpeed - 1.5707964E-4f);
        rotation.setSpeed(nextSpeed);
    }

    public static boolean isObstructedBySolidBlocks(Level level, BlockPos pos, Direction.Axis axis) {
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (int dH = -6; dH <= 6; ++dH) {
            for (int dy = -6; dy <= 6; ++dy) {
                if (dH * dH + dy * dy >= 49 || dH == 0 && dy == 0) continue;
                cursor.m_122154_((Vec3i)pos, axis == Direction.Axis.X ? 0 : dH, dy, axis == Direction.Axis.Z ? 0 : dH);
                BlockState state = level.m_8055_((BlockPos)cursor);
                if (state.m_60795_() || state.m_60812_((BlockGetter)level, (BlockPos)cursor).m_83281_()) continue;
                return true;
            }
        }
        return false;
    }

    public WindmillBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<?>)((BlockEntityType)TFCBlockEntities.WINDMILL.get()), pos, state, WindmillBlockEntity.defaultInventory(5), NAME);
    }

    public WindmillBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, InventoryBlockEntity.InventoryFactory<ItemStackHandler> inventory, Component defaultName) {
        super(type, pos, state, inventory, defaultName);
        final Direction.Axis axis = (Direction.Axis)state.m_61143_(WindmillBlock.AXIS);
        this.invalid = false;
        this.node = new SourceNode(pos, Node.ofAxis(axis), Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE), 0.0f){

            @Override
            public String toString() {
                return "Windmill[pos=%s, axis=%s]".formatted(this.pos(), axis);
            }
        };
    }

    public int updateState() {
        assert (this.f_58857_ != null);
        this.needsStateUpdate = false;
        int count = 0;
        for (ItemStack stack : Helpers.iterate((IItemHandler)this.inventory)) {
            if (stack.m_41619_()) continue;
            ++count;
        }
        if (count == 0) {
            BlockState currentState = this.m_58900_();
            BlockState axleState = (BlockState)((WindmillBlock)currentState.m_60734_()).getAxle().m_49966_().m_61124_((Property)AxleBlock.f_55923_, (Comparable)((Direction.Axis)currentState.m_61143_(WindmillBlock.AXIS)));
            this.f_58857_.m_46597_(this.f_58858_, axleState);
        } else {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)WindmillBlock.COUNT, (Comparable)Integer.valueOf(count)));
        }
        return count;
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.needsStateUpdate = true;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return Helpers.isItem(stack, TFCTags.Items.ALL_WINDMILL_BLADES);
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return 1;
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.node.rotation().saveToTag(tag);
        tag.m_128379_("invalid", this.invalid);
    }

    @Override
    public void loadAdditional(CompoundTag tag) {
        super.loadAdditional(tag);
        this.node.rotation().loadFromTag(tag);
        this.invalid = tag.m_128471_("invalid");
    }

    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    protected void onLoadAdditional() {
        this.performNetworkAction(NetworkAction.ADD_SOURCE);
    }

    @Override
    protected void onUnloadAdditional() {
        this.performNetworkAction(NetworkAction.REMOVE);
    }

    @Override
    public void markAsInvalidInNetwork() {
        this.invalid = true;
    }

    @Override
    public boolean isInvalidInNetwork() {
        return this.invalid;
    }

    @Override
    public Node getRotationNode() {
        return this.node;
    }
}

