/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.blocks.devices.SluiceBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Sluiceable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class SluiceBlockEntity
extends TickableInventoryBlockEntity<ItemStackHandler> {
    public static final int MAX_SOIL = 32;
    private static final Component NAME = Component.m_237115_((String)"tfc.block_entity.sluice");
    private int ticksRemaining = 0;

    public static void serverTick(Level level, BlockPos pos, BlockState state, SluiceBlockEntity sluice) {
        BlockPos fluidOutputPos;
        Fluid fluid;
        BlockPos outputPos;
        Fluid fluid2;
        boolean activeTick;
        if (!((Boolean)state.m_61143_((Property)SluiceBlock.UPPER)).booleanValue()) {
            return;
        }
        State sluiceState = sluice.getRepresentativeState();
        if (sluiceState == State.NONE) {
            return;
        }
        sluice.checkForLastTickSync();
        boolean bl = activeTick = level.m_46467_() % 20L == 0L;
        if (sluiceState == State.BOTH && activeTick) {
            Helpers.gatherAndConsumeItems(level, new AABB((double)-0.2f, 0.5, (double)-0.2f, (double)1.2f, 1.25, (double)1.2f).m_82338_(pos), (IItemHandler)sluice.inventory, 0, 31, 1);
        }
        if (sluiceState == State.BOTH && --sluice.ticksRemaining <= 0) {
            boolean itemUsed = false;
            for (ItemStack stack : Helpers.iterate((IItemHandler)sluice.inventory)) {
                if (stack.m_41619_()) continue;
                Sluiceable sluiceable = Sluiceable.get(stack);
                if (sluiceable != null && level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    LootParams.Builder params = new LootParams.Builder(serverLevel).m_287289_(LootContextParams.f_81460_, (Object)new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
                    LootTable table = serverLevel.m_7654_().m_278653_().m_278676_(sluiceable.getLootTable());
                    ObjectArrayList items = table.m_287195_(params.m_287235_(LootContextParamSets.f_81410_));
                    items.forEach(item -> Helpers.spawnItem(level, Vec3.m_82512_((Vec3i)sluice.getWaterOutputPos()), item));
                }
                stack.m_41764_(0);
                itemUsed = true;
                break;
            }
            if (itemUsed) {
                Helpers.playSound(level, sluice.m_58899_(), SoundEvents.f_12019_);
            }
            sluice.ticksRemaining = (Integer)TFCConfig.SERVER.sluiceTicks.get();
            sluice.markForSync();
        }
        if (!activeTick) {
            return;
        }
        if (sluiceState == State.INPUT_ONLY && !(fluid2 = level.m_6425_(sluice.getWaterInputPos()).m_76152_()).m_6212_(Fluids.f_76191_) && sluice.isFluidValid(fluid2) && level.m_8055_(outputPos = sluice.getWaterOutputPos()).m_247087_()) {
            FluidHelpers.setSourceBlock(level, outputPos, fluid2);
        }
        if (sluiceState == State.OUTPUT_ONLY && sluice.isFluidValid(fluid = level.m_6425_(fluidOutputPos = sluice.getWaterOutputPos()).m_76152_())) {
            BlockState outputState = level.m_8055_(fluidOutputPos);
            BlockState resultState = FluidHelpers.emptyFluidFrom(outputState);
            level.m_46597_(fluidOutputPos, resultState);
            if (!resultState.m_60795_()) {
                level.m_186460_(fluidOutputPos, resultState.m_60734_(), 1);
            }
        }
    }

    public SluiceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.SLUICE.get(), pos, state, SluiceBlockEntity.defaultInventory(32), NAME);
    }

    @Override
    public void loadAdditional(CompoundTag nbt) {
        this.ticksRemaining = nbt.m_128451_("ticksRemaining");
        super.loadAdditional(nbt);
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        nbt.m_128405_("ticksRemaining", this.ticksRemaining);
        super.m_183515_(nbt);
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return 1;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return Sluiceable.get(stack) != null;
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.markForSync();
    }

    public Direction getFacing() {
        return (Direction)this.m_58900_().m_61143_((Property)SluiceBlock.FACING);
    }

    public BlockPos getWaterOutputPos() {
        return SluiceBlock.getFluidOutputPos(this.m_58900_(), this.m_58899_());
    }

    public BlockPos getWaterInputPos() {
        return this.m_58899_().m_7494_().m_121945_(this.getFacing().m_122424_());
    }

    @Nullable
    public Fluid getFlow() {
        assert (this.f_58857_ != null);
        FluidState inputState = this.f_58857_.m_6425_(this.getWaterInputPos());
        Fluid input = inputState.m_76152_();
        Fluid output = this.f_58857_.m_6425_(this.getWaterOutputPos()).m_76152_();
        if (inputState.m_61138_((Property)FlowingFluid.f_75948_) && (Integer)inputState.m_61143_((Property)FlowingFluid.f_75948_) == 1 && this.isFluidValid(input) && output.m_6212_(input)) {
            return input;
        }
        return null;
    }

    private State getRepresentativeState() {
        assert (this.f_58857_ != null);
        FluidState inputState = this.f_58857_.m_6425_(this.getWaterInputPos());
        Fluid input = inputState.m_76152_();
        Fluid output = this.f_58857_.m_6425_(this.getWaterOutputPos()).m_76152_();
        boolean isInputValid = this.isFluidValid(input) && inputState.m_61138_((Property)FlowingFluid.f_75948_) && (Integer)inputState.m_61143_((Property)FlowingFluid.f_75948_) == 1;
        boolean isOutputValid = this.isFluidValid(output);
        return isInputValid ? (isOutputValid && output.m_6212_(input) ? State.BOTH : State.INPUT_ONLY) : (isOutputValid ? State.OUTPUT_ONLY : State.NONE);
    }

    public boolean isFluidValid(Fluid fluid) {
        return Helpers.isFluid(fluid, TFCTags.Fluids.USABLE_IN_SLUICE);
    }

    static enum State {
        NONE,
        INPUT_ONLY,
        OUTPUT_ONLY,
        BOTH;

    }
}

