/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.container.LogPileContainer;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class LogPileBlockEntity
extends InventoryBlockEntity<ItemStackHandler>
implements MenuProvider {
    public static final int SLOTS = 4;
    private static final Component NAME = Component.m_237115_((String)"tfc.block_entity.log_pile");
    private int playersUsing = 0;

    public LogPileBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.LOG_PILE.get(), pos, state, LogPileBlockEntity.defaultInventory(4), NAME);
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        if (this.f_58857_ != null && !this.f_58857_.m_5776_() && this.playersUsing == 0 && this.isEmpty()) {
            this.f_58857_.m_46597_(this.f_58858_, Blocks.f_50016_.m_49966_());
        }
    }

    public void onOpen(Player player) {
        if (!player.m_5833_()) {
            ++this.playersUsing;
        }
    }

    public void onClose(Player player) {
        if (!player.m_5833_()) {
            --this.playersUsing;
            if (this.playersUsing < 0) {
                this.playersUsing = 0;
            }
            this.setAndUpdateSlots(-1);
        }
    }

    public boolean isEmpty() {
        for (ItemStack stack : Helpers.iterate((IItemHandler)this.inventory)) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public int logCount() {
        int count = 0;
        for (ItemStack stack : Helpers.iterate((IItemHandler)this.inventory)) {
            count += stack.m_41613_();
        }
        return count;
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return 4;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return Helpers.isItem(stack.m_41720_(), TFCTags.Items.LOG_PILE_LOGS);
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int windowID, Inventory inv, Player player) {
        return LogPileContainer.create(this, inv, windowID);
    }
}

