/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.LargeVesselBlock;
import net.dries007.tfc.common.capabilities.InventoryItemHandler;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTraits;
import net.dries007.tfc.common.capabilities.size.ItemSizeManager;
import net.dries007.tfc.common.capabilities.size.Size;
import net.dries007.tfc.common.container.LargeVesselContainer;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LargeVesselBlockEntity
extends InventoryBlockEntity<VesselInventory> {
    public static final int SLOTS = 9;
    private static final Component NAME = Component.m_237115_((String)"tfc.block_entity.large_vessel");

    public LargeVesselBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends LargeVesselBlockEntity>)((BlockEntityType)TFCBlockEntities.LARGE_VESSEL.get()), pos, state);
    }

    public LargeVesselBlockEntity(BlockEntityType<? extends LargeVesselBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state, VesselInventory::new, NAME);
        if (((Boolean)TFCConfig.SERVER.largeVesselEnableAutomation.get()).booleanValue()) {
            this.sidedInventory.on(new PartialItemHandler(this.inventory).insert(0, 1, 2, 3, 4, 5, 6, 7, 8), d -> d != Direction.DOWN);
            this.sidedInventory.on(new PartialItemHandler(this.inventory).extract(0, 1, 2, 3, 4, 5, 6, 7, 8), Direction.DOWN);
        }
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int windowID, Inventory inv, Player player) {
        return LargeVesselContainer.create(this, inv, windowID);
    }

    public void onUnseal() {
        assert (this.f_58857_ != null);
        for (int i = 0; i < 9; ++i) {
            ((VesselInventory)this.inventory).setStackInSlot(i, FoodCapability.removeTrait(((VesselInventory)this.inventory).getStackInSlot(i).m_41777_(), FoodTraits.PRESERVED));
        }
        Helpers.playSound(this.f_58857_, this.f_58858_, (SoundEvent)TFCSounds.OPEN_VESSEL.get());
    }

    public void onSeal() {
        assert (this.f_58857_ != null);
        for (int i = 0; i < 9; ++i) {
            ((VesselInventory)this.inventory).setStackInSlot(i, FoodCapability.applyTrait(((VesselInventory)this.inventory).getStackInSlot(i).m_41777_(), FoodTraits.PRESERVED));
        }
        Helpers.playSound(this.f_58857_, this.f_58858_, (SoundEvent)TFCSounds.CLOSE_VESSEL.get());
    }

    public static class VesselInventory
    extends InventoryItemHandler
    implements INBTSerializable<CompoundTag> {
        private final LargeVesselBlockEntity vessel;

        VesselInventory(InventoryBlockEntity<?> entity) {
            super(entity, 9);
            this.vessel = (LargeVesselBlockEntity)entity;
        }

        @NotNull
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.canModify() ? super.insertItem(slot, stack, simulate) : stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.canModify() ? super.extractItem(slot, amount, simulate) : ItemStack.f_41583_;
        }

        @Override
        public boolean isItemValid(int slot, ItemStack stack) {
            return this.canModify() && ItemSizeManager.get(stack).getSize(stack).isSmallerThan(Size.LARGE) && super.isItemValid(slot, stack);
        }

        private boolean canModify() {
            return (Boolean)this.vessel.m_58900_().m_61143_((Property)LargeVesselBlock.SEALED) == false;
        }
    }
}

