/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.List;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.dries007.tfc.common.blockentities.rotation.CrankshaftBlockEntity;
import net.dries007.tfc.common.blocks.devices.BellowsBlock;
import net.dries007.tfc.common.blocks.devices.IBellowsConsumer;
import net.dries007.tfc.util.rotation.Rotation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BellowsBlockEntity
extends TFCBlockEntity {
    public static final int BELLOWS_AIR = 200;
    public static final int MAX_DEVICE_AIR_TICKS = 600;
    public static final float MIN_EXTENSION = 0.125f;
    public static final float MAX_EXTENSION = 0.625f;
    private long lastPushed = 0L;
    private boolean justPushed = false;

    public static void tickBoth(Level level, BlockPos pos, BlockState state, BellowsBlockEntity bellows) {
        @Nullable Rotation networkRotation = bellows.getCrankRotation();
        float extension = bellows.getExtensionLength(1.0f);
        if (extension > 0.575f && !bellows.justPushed && bellows.lastPushed + 20L < level.m_46467_() && networkRotation != null) {
            bellows.doPush();
            bellows.justPushed = true;
            bellows.lastPushed = level.m_46467_() - 20L + (long)Math.max(20, (int)(5.0265484f / networkRotation.speed()));
        } else if (bellows.justPushed) {
            bellows.justPushed = false;
            bellows.afterPush();
        }
        if (extension >= 0.625f) {
            return;
        }
        Direction direction = ((Direction)state.m_61143_((Property)BellowsBlock.FACING)).m_122424_();
        AABB bounds = state.m_60808_((BlockGetter)level, pos).m_83215_().m_82338_(pos);
        List list = level.m_45933_(null, bounds);
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (entity.m_7752_() == PushReaction.IGNORE) continue;
                entity.m_6478_(MoverType.SHULKER_BOX, new Vec3(0.1 * (double)direction.m_122429_(), 0.0, 0.1 * (double)direction.m_122431_()));
            }
        }
    }

    public BellowsBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public BellowsBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.BELLOWS.get(), pos, state);
    }

    public boolean isConnectedToNetwork() {
        return this.getCrankRotation() != null;
    }

    @Nullable
    public Rotation getCrankRotation() {
        CrankshaftBlockEntity crank = this.getCrankBlockEntity();
        return crank == null ? null : crank.getRotationNode().rotation();
    }

    @Nullable
    public CrankshaftBlockEntity getCrankBlockEntity() {
        return this.f_58857_ == null ? null : CrankshaftBlockEntity.getCrankShaftAt((LevelAccessor)this.f_58857_, this.f_58858_, ((Direction)this.m_58900_().m_61143_((Property)BellowsBlock.FACING)).m_122424_());
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128356_("pushed", this.lastPushed);
        tag.m_128379_("justPushed", this.justPushed);
    }

    @Override
    protected void loadAdditional(CompoundTag tag) {
        super.loadAdditional(tag);
        this.lastPushed = tag.m_128454_("pushed");
        this.justPushed = tag.m_128471_("justPushed");
    }

    public float getExtensionLength(float partialTick) {
        if (this.f_58857_ == null) {
            return 0.125f;
        }
        CrankshaftBlockEntity entity = this.getCrankBlockEntity();
        if (entity != null) {
            return Mth.m_14036_((float)(0.125f + entity.getExtensionLength(partialTick)), (float)0.125f, (float)0.625f);
        }
        int time = (int)(this.f_58857_.m_46467_() - this.lastPushed);
        if (time < 10) {
            return (float)time * 0.05f + 0.125f;
        }
        if (time < 20) {
            return (float)(20 - time) * 0.05f + 0.125f;
        }
        return 0.125f;
    }

    public InteractionResult onRightClick() {
        assert (this.f_58857_ != null);
        if (this.f_58857_.m_46467_() - this.lastPushed < 20L || this.isConnectedToNetwork()) {
            return InteractionResult.PASS;
        }
        this.doPush();
        return InteractionResult.SUCCESS;
    }

    private void doPush() {
        assert (this.f_58857_ != null);
        if (this.f_58857_.f_46443_) {
            return;
        }
        boolean foundAnyReceivers = false;
        boolean foundAnyAllowingReceivers = false;
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)BellowsBlock.FACING);
        for (IBellowsConsumer.Offset offset : IBellowsConsumer.offsets()) {
            BlockPos airPosition = this.f_58858_.m_6630_(offset.up()).m_5484_(direction, offset.out()).m_5484_(direction.m_122427_(), offset.side());
            BlockState state = this.f_58857_.m_8055_(airPosition);
            Block block = state.m_60734_();
            if (!(block instanceof IBellowsConsumer)) continue;
            IBellowsConsumer consumer = (IBellowsConsumer)block;
            foundAnyReceivers = true;
            if (!consumer.canAcceptAir(this.f_58857_, airPosition, state)) continue;
            foundAnyAllowingReceivers = true;
            consumer.intakeAir(this.f_58857_, airPosition, state, 200);
        }
        if (!foundAnyReceivers || foundAnyAllowingReceivers) {
            this.lastPushed = this.f_58857_.m_46467_();
            this.justPushed = true;
            this.markForSync();
            this.afterPush();
        }
    }

    private void afterPush() {
        assert (this.f_58857_ != null);
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)BellowsBlock.FACING);
        BlockPos facingPos = this.f_58858_.m_121945_(direction);
        this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)TFCSounds.BELLOWS_BLOW.get(), SoundSource.BLOCKS, 1.0f, 1.0f + (this.f_58857_.f_46441_.m_188501_() - this.f_58857_.f_46441_.m_188501_()) / 16.0f);
        this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, (double)((float)facingPos.m_123341_() + 0.5f - 0.3f * (float)direction.m_122429_()), (double)((float)facingPos.m_123342_() + 0.5f), (double)((float)facingPos.m_123343_() + 0.5f - 0.3f * (float)direction.m_122431_()), 0.0, 0.005, 0.0);
    }

    public int getTicksSincePushed() {
        assert (this.f_58857_ != null);
        return (int)(this.f_58857_.m_46467_() - this.lastPushed);
    }
}

