/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import net.dries007.tfc.client.screen.BlockEntityScreen;
import net.dries007.tfc.client.screen.button.AnvilPlanButton;
import net.dries007.tfc.client.screen.button.AnvilStepButton;
import net.dries007.tfc.common.blockentities.AnvilBlockEntity;
import net.dries007.tfc.common.capabilities.forge.ForgeRule;
import net.dries007.tfc.common.capabilities.forge.ForgeStep;
import net.dries007.tfc.common.capabilities.forge.ForgeSteps;
import net.dries007.tfc.common.capabilities.forge.Forging;
import net.dries007.tfc.common.container.AnvilContainer;
import net.dries007.tfc.common.recipes.AnvilRecipe;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AnvilScreen
extends BlockEntityScreen<AnvilBlockEntity, AnvilContainer> {
    public static final ResourceLocation BACKGROUND = Helpers.identifier("textures/gui/anvil.png");

    public AnvilScreen(AnvilContainer container, Inventory playerInventory, Component name) {
        super(container, playerInventory, name, BACKGROUND);
        this.f_97731_ += 41;
        this.f_97727_ += 41;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new AnvilPlanButton((AnvilBlockEntity)this.blockEntity, this.getGuiLeft(), this.getGuiTop()));
        for (ForgeStep step : ForgeStep.VALUES) {
            this.m_142416_((GuiEventListener)new AnvilStepButton(step, this.getGuiLeft(), this.getGuiTop()));
        }
    }

    @Override
    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(graphics, partialTicks, mouseX, mouseY);
        Level level = ((AnvilBlockEntity)this.blockEntity).m_58904_();
        int guiLeft = this.getGuiLeft();
        int guiTop = this.getGuiTop();
        if (Helpers.isJEIEnabled()) {
            graphics.m_280218_(this.texture, guiLeft + 26, guiTop + 24, 0, 207, 9, 14);
        }
        assert (level != null);
        @Nullable Forging forging = ((AnvilBlockEntity)this.blockEntity).getMainInputForging();
        if (forging != null) {
            int xOffset;
            int i;
            int progress = forging.getWork();
            graphics.m_280218_(this.texture, guiLeft + 13 + progress, guiTop + 100, 176, 0, 5, 5);
            int target = forging.getWorkTarget();
            graphics.m_280218_(this.texture, guiLeft + 13 + target, guiTop + 94, 181, 0, 5, 5);
            ForgeSteps steps = forging.getSteps();
            AnvilRecipe recipe = forging.getRecipe(level);
            if (recipe != null) {
                ForgeRule[] rules = recipe.getRules();
                for (i = 0; i < rules.length; ++i) {
                    ForgeRule rule = rules[i];
                    if (rule == null) continue;
                    xOffset = i * 19;
                    graphics.m_280411_(this.texture, guiLeft + 64 + xOffset, guiTop + 10, 10, 10, (float)rule.iconX(), (float)rule.iconY(), 32, 32, 256, 256);
                    if (rule.matches(steps)) {
                        RenderSystem.setShaderColor((float)0.0f, (float)0.6f, (float)0.2f, (float)1.0f);
                    } else {
                        RenderSystem.setShaderColor((float)1.0f, (float)0.4f, (float)0.0f, (float)1.0f);
                    }
                    graphics.m_280218_(this.texture, guiLeft + 59 + xOffset, guiTop + 7, 198, rule.overlayY(), 20, 22);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
            ForgeStep[] stepSequence = new ForgeStep[]{steps.last(), steps.secondLast(), steps.thirdLast()};
            for (i = 0; i < 3; ++i) {
                ForgeStep step = stepSequence[i];
                if (step == null) continue;
                xOffset = i * 19;
                graphics.m_280411_(this.texture, guiLeft + 64 + xOffset, guiTop + 31, 10, 10, (float)step.iconX(), (float)step.iconY(), 32, 32, 256, 256);
            }
        }
    }

    protected void m_280072_(GuiGraphics graphics, int mouseX, int mouseY) {
        AnvilRecipe recipe;
        super.m_280072_(graphics, mouseX, mouseY);
        Level level = ((AnvilBlockEntity)this.blockEntity).m_58904_();
        @Nullable Forging forging = ((AnvilBlockEntity)this.blockEntity).getMainInputForging();
        if (forging != null && level != null && (recipe = forging.getRecipe(level)) != null) {
            ForgeRule[] rules = recipe.getRules();
            for (int i = 0; i < rules.length; ++i) {
                ForgeRule rule = rules[i];
                if (rule == null) continue;
                int xOffset = i * 19;
                int x = this.getGuiLeft() + 64 + xOffset;
                int y = this.getGuiTop() + 10;
                if (mouseX <= x || mouseX >= x + 10 || mouseY <= y || mouseY >= y + 10) continue;
                graphics.m_280557_(this.f_96547_, rule.getDescriptionId(), mouseX, mouseY);
            }
        }
    }
}

