/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.render.entity.TFCBoatRenderer;
import net.dries007.tfc.common.entities.misc.TFCChestBoat;
import net.dries007.tfc.common.items.ChestBlockItem;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ChestRaftModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.joml.Quaternionf;

public class TFCChestBoatRenderer
extends TFCBoatRenderer {
    private static final ResourceLocation DEFAULT_TEXTURE = Helpers.identifier("textures/entity/chest_boat/oak.png");
    private final ListModel<Boat> model;

    public static ModelLayerLocation chestBoatName(String name) {
        return RenderHelpers.modelIdentifier("chest_boat/" + name);
    }

    public TFCChestBoatRenderer(EntityRendererProvider.Context context, String name) {
        super(context, name);
        ModelPart part = context.m_174023_(TFCChestBoatRenderer.chestBoatName(name));
        this.model = name.equals("palm") ? new ChestRaftModel(part) : new ChestBoatModel(part);
    }

    public TFCChestBoatRenderer(EntityRendererProvider.Context context, Pair<ResourceLocation, ListModel<Boat>> originalPair, BoatModel model) {
        super(context, originalPair);
        this.model = model;
    }

    public void m_7392_(Boat boat, float ageInTicks, float pitch, PoseStack poseStack, MultiBufferSource buffers, int packedLight) {
        if (boat instanceof TFCChestBoat) {
            float f2;
            TFCChestBoat chest = (TFCChestBoat)boat;
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.375f, 0.0f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - ageInTicks));
            float f = (float)boat.m_38385_() - pitch;
            float f1 = boat.m_38384_() - pitch;
            if (f1 < 0.0f) {
                f1 = 0.0f;
            }
            if (f > 0.0f) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)f) * f * f1 / 10.0f * (float)boat.m_38386_()));
            }
            if (!Mth.m_14033_((float)(f2 = boat.m_38352_(pitch)), (float)0.0f)) {
                poseStack.m_252781_(new Quaternionf().setAngleAxis(boat.m_38352_(pitch) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
            }
            poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            this.model.m_6973_((Entity)chest, pitch, 0.0f, -0.1f, 0.0f, 0.0f);
            VertexConsumer vertexconsumer = buffers.m_6299_(this.model.m_103119_(this.getChestTexture(chest)));
            this.model.m_7695_(poseStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
        }
        super.m_7392_(boat, ageInTicks, pitch, poseStack, buffers, packedLight);
    }

    protected ResourceLocation getChestTexture(TFCChestBoat chest) {
        ResourceLocation resourceLocation;
        ItemStack stack = chest.getChestItem();
        Item item = stack.m_41720_();
        if (item instanceof ChestBlockItem) {
            ChestBlockItem item2 = (ChestBlockItem)item;
            resourceLocation = item2.getBoatTexture();
        } else {
            resourceLocation = DEFAULT_TEXTURE;
        }
        return resourceLocation;
    }
}

