/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.common.blockentities.rotation.TripHammerBlockEntity;
import net.dries007.tfc.common.blocks.TripHammerBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.items.HammerItem;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.rotation.Rotation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TripHammerBlockEntityRenderer
implements BlockEntityRenderer<TripHammerBlockEntity> {
    private static final ResourceLocation ROD_TEXTURE = Helpers.identifier("block/wood/planks/oak");

    public void render(TripHammerBlockEntity hammer, float partialTick, PoseStack stack, MultiBufferSource buffers, int packedLight, int packedOverlay) {
        ResourceLocation hammerTexture;
        BlockState state = hammer.m_58900_();
        Level level = hammer.m_58904_();
        Rotation rotation = hammer.getRotation();
        if (level == null || !(state.m_60734_() instanceof TripHammerBlock)) {
            return;
        }
        ItemStack item = hammer.getCapability(Capabilities.ITEM).map(inv -> inv.getStackInSlot(0)).orElse(ItemStack.f_41583_);
        Item item2 = item.m_41720_();
        if (item2 instanceof HammerItem) {
            HammerItem hammerItem = (HammerItem)item2;
            v0 = hammerItem.getMetalTexture();
        } else {
            v0 = hammerTexture = null;
        }
        if (hammerTexture == null) {
            return;
        }
        VertexConsumer buffer = buffers.m_6299_(RenderType.m_110463_());
        float px = 0.0625f;
        stack.m_85836_();
        stack.m_252880_(0.5f, 0.5f, 0.5f);
        stack.m_252781_(Axis.f_252436_.m_252977_(180.0f - 90.0f * (float)((Direction)state.m_61143_((Property)TripHammerBlock.FACING)).m_122416_()));
        stack.m_252880_(-0.5f, -0.5f, -0.5f);
        float angle = rotation == null ? 0.0f : 360.0f - hammer.getRealRotationDegrees(rotation, partialTick);
        float pivotStart = 130.0f;
        float pivotMiddle = 180.0f;
        float pivotEnd = 183.0f;
        float pivotAngle = 0.0f;
        if (angle > 130.0f && angle < 180.0f) {
            pivotAngle = Mth.m_184637_((float)angle, (float)130.0f, (float)180.0f, (float)0.0f, (float)45.0f);
        } else if (angle > 180.0f && angle < 183.0f) {
            pivotAngle = 45.0f - Mth.m_184637_((float)angle, (float)180.0f, (float)183.0f, (float)0.0f, (float)45.0f);
        }
        float pivotX = 0.5f;
        float pivotY = 0.875f;
        float pivotZ = 0.1875f;
        if (pivotAngle != 0.0f && rotation.positiveDirection() == ((Direction)state.m_61143_((Property)TripHammerBlock.FACING)).m_122427_()) {
            stack.m_252880_(0.5f, 0.875f, 0.1875f);
            stack.m_252781_(Axis.f_252495_.m_252977_(-pivotAngle));
            stack.m_252880_(-0.5f, -0.875f, -0.1875f);
        }
        RenderHelpers.renderTexturedCuboid(stack, buffer, RenderHelpers.blockTexture(ROD_TEXTURE), packedLight, packedOverlay, 0.40625f, 0.78125f, -0.375f, 0.59375f, 0.96875f, 0.625f, false);
        RenderHelpers.renderTexturedCuboid(stack, buffer, RenderHelpers.blockTexture(hammerTexture), packedLight, packedOverlay, 0.34375f, 0.6875f, -0.6875f, 0.65625f, 1.0625f, -0.375f, false);
        stack.m_85849_();
    }
}

