/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.stream.Stream;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.mixin.client.accessor.SignRendererAccessor;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;

public class TFCSignBlockEntityRenderer
extends SignRenderer {
    private final Map<WoodType, SignRenderer.SignModel> signModels;

    public TFCSignBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this(context, TFCBlocks.WOODS.keySet().stream().map(map -> new SignModelData("tfc", map.m_7912_(), map.getVanillaWoodType())));
    }

    public TFCSignBlockEntityRenderer(BlockEntityRendererProvider.Context context, Stream<SignModelData> blocks) {
        super(context);
        ImmutableMap.Builder modelBuilder = ImmutableMap.builder();
        blocks.forEach(data -> modelBuilder.put((Object)data.type, (Object)new SignRenderer.SignModel(context.m_173582_(new ModelLayerLocation(Helpers.resourceLocation(data.domain, "sign/" + data.name), "main")))));
        this.signModels = modelBuilder.build();
    }

    public void m_6922_(SignBlockEntity sign, float partialTicks, PoseStack poseStack, MultiBufferSource source, int packedLight, int overlay) {
        BlockState blockstate = sign.m_58900_();
        SignBlock signblock = (SignBlock)blockstate.m_60734_();
        WoodType woodType = SignBlock.m_247329_((Block)signblock);
        SignRenderer.SignModel model = this.signModels.get(woodType);
        model.f_112507_.f_104207_ = blockstate.m_60734_() instanceof StandingSignBlock;
        ((SignRendererAccessor)((Object)this)).invoke$renderSignWithText(sign, poseStack, source, packedLight, overlay, blockstate, signblock, woodType, (Model)model);
    }

    public record SignModelData(String domain, String name, WoodType type) {
    }
}

