/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.dries007.tfc.client.render.blockentity.TFCSignBlockEntityRenderer;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.mixin.client.accessor.SignRendererAccessor;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import org.jetbrains.annotations.Nullable;

public class TFCHangingSignBlockEntityRenderer
extends HangingSignRenderer {
    private static final Map<Block, HangingSignModelData> RENDER_INFO = new HashMap<Block, HangingSignModelData>();
    private final Map<WoodType, HangingSignRenderer.HangingSignModel> hangingSignModels;

    @Nullable
    public static HangingSignModelData getData(Block block) {
        return RENDER_INFO.get(block);
    }

    public static synchronized void registerData(Block block, HangingSignModelData modelData) {
        RENDER_INFO.put(block, modelData);
    }

    public static HangingSignModelData createModelData(ResourceLocation signLocation, ResourceLocation guiLocation) {
        return new HangingSignModelData(new Material(Sheets.f_110739_, signLocation), guiLocation);
    }

    private static HangingSignModelData createModelData(Metal.Default metal, Supplier<? extends SignBlock> reg) {
        WoodType type = reg.get().m_56297_();
        ResourceLocation woodName = Helpers.resourceLocation(type.f_61839_());
        ResourceLocation metalName = Helpers.identifier(metal.m_7912_());
        return TFCHangingSignBlockEntityRenderer.createModelData(Helpers.resourceLocation(woodName.m_135827_(), "entity/signs/hanging/" + metalName.m_135815_() + "/" + woodName.m_135815_()), Helpers.resourceLocation(type.f_61839_() + ".png").m_246208_("textures/gui/hanging_signs/" + metalName.m_135815_() + "/"));
    }

    public TFCHangingSignBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this(context, TFCBlocks.WOODS.keySet().stream().map(map -> new TFCSignBlockEntityRenderer.SignModelData("tfc", map.m_7912_(), map.getVanillaWoodType())));
    }

    public TFCHangingSignBlockEntityRenderer(BlockEntityRendererProvider.Context context, Stream<TFCSignBlockEntityRenderer.SignModelData> blocks) {
        super(context);
        ImmutableMap.Builder modelBuilder = ImmutableMap.builder();
        blocks.forEach(data -> modelBuilder.put((Object)data.type(), (Object)new HangingSignRenderer.HangingSignModel(context.m_173582_(new ModelLayerLocation(Helpers.resourceLocation(data.domain(), "hanging_sign/" + data.name()), "main")))));
        this.hangingSignModels = modelBuilder.build();
    }

    public void m_6922_(SignBlockEntity sign, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        BlockState state = sign.m_58900_();
        SignBlock signBlock = (SignBlock)state.m_60734_();
        WoodType woodType = SignBlock.m_247329_((Block)signBlock);
        HangingSignRenderer.HangingSignModel model = this.hangingSignModels.get(woodType);
        HangingSignModelData modelData = Objects.requireNonNull(TFCHangingSignBlockEntityRenderer.getData((Block)signBlock));
        model.m_246561_(state);
        this.renderSignWithText(sign, poseStack, buffer, light, overlay, state, signBlock, modelData.modelMaterial(), (Model)model);
    }

    void renderSignWithText(SignBlockEntity sign, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, BlockState blockstate, SignBlock signblock, Material modelMaterial, Model model) {
        poseStack.m_85836_();
        ((SignRendererAccessor)((Object)this)).invoke$translateSign(poseStack, -signblock.m_276903_(blockstate), blockstate);
        this.renderSign(poseStack, buffer, light, overlay, modelMaterial, model);
        ((SignRendererAccessor)((Object)this)).invoke$renderSignText(sign.m_58899_(), sign.m_277142_(), poseStack, buffer, light, sign.m_245065_(), sign.m_245123_(), true);
        ((SignRendererAccessor)((Object)this)).invoke$renderSignText(sign.m_58899_(), sign.m_277159_(), poseStack, buffer, light, sign.m_245065_(), sign.m_245123_(), false);
        poseStack.m_85849_();
    }

    void renderSign(PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, Material modelMaterial, Model model) {
        poseStack.m_85836_();
        float f = this.m_278770_();
        poseStack.m_85841_(f, -f, -f);
        VertexConsumer vertexconsumer = modelMaterial.m_119194_(buffer, arg_0 -> ((Model)model).m_103119_(arg_0));
        ((SignRendererAccessor)((Object)this)).invoke$renderSignModel(poseStack, light, overlay, model, vertexconsumer);
        poseStack.m_85849_();
    }

    static {
        TFCBlocks.CEILING_HANGING_SIGNS.forEach((wood, map) -> map.forEach((metal, reg) -> RENDER_INFO.put((Block)reg.get(), TFCHangingSignBlockEntityRenderer.createModelData(metal, (Supplier<? extends SignBlock>)reg))));
        TFCBlocks.WALL_HANGING_SIGNS.forEach((wood, map) -> map.forEach((metal, reg) -> RENDER_INFO.put((Block)reg.get(), TFCHangingSignBlockEntityRenderer.createModelData(metal, (Supplier<? extends SignBlock>)reg))));
    }

    public record HangingSignModelData(Material modelMaterial, ResourceLocation textureLocation) {
    }
}

