/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.math.Transformation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.model.ContainedFluidModel;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraftforge.client.ForgeRenderTypes;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.CompositeModel;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.geometry.StandaloneGeometryBakingContext;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import org.jetbrains.annotations.Nullable;

public record TrimmedItemModel(@Nullable ArmorTrim trim) implements IUnbakedGeometry<TrimmedItemModel>
{
    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        TextureAtlasSprite baseSprite = spriteGetter.apply(context.getMaterial("armor"));
        TextureAtlasSprite overlaySprite = context.hasMaterial("overlay") ? spriteGetter.apply(context.getMaterial("overlay")) : null;
        ResourceLocation trimLocation = context.getMaterial("trim").m_119203_();
        String color = this.trim != null ? ((TrimMaterial)this.trim.m_266210_().get()).f_265854_() : null;
        TextureAtlasSprite trimSprite = this.trim != null ? spriteGetter.apply(new Material(RenderHelpers.BLOCKS_ATLAS, trimLocation.m_266382_("_" + color))) : null;
        StandaloneGeometryBakingContext itemContext = StandaloneGeometryBakingContext.builder((IGeometryBakingContext)context).withGui3d(false).withUseBlockLight(false).build(modelLocation);
        CompositeModel.Baked.Builder builder = CompositeModel.Baked.builder((IGeometryBakingContext)itemContext, (TextureAtlasSprite)baseSprite, (ItemOverrides)new TrimOverrideHandler(overrides, baker, (IGeometryBakingContext)itemContext, this), (ItemTransforms)context.getTransforms());
        RenderTypeGroup normalRenderTypes = new RenderTypeGroup(RenderType.m_110466_(), ForgeRenderTypes.ITEM_UNSORTED_TRANSLUCENT.get());
        TrimmedItemModel.addQuads(modelState, modelLocation, baseSprite, builder, normalRenderTypes, ContainedFluidModel.FLUID_TRANSFORM);
        if (overlaySprite != null) {
            TrimmedItemModel.addQuads(modelState, modelLocation, overlaySprite, builder, normalRenderTypes, ContainedFluidModel.FLUID_TRANSFORM);
        }
        if (trimSprite != null) {
            TrimmedItemModel.addQuads(modelState, modelLocation, trimSprite, builder, normalRenderTypes, ContainedFluidModel.COVER_TRANSFORM);
        }
        builder.setParticle(baseSprite);
        return builder.build();
    }

    private static void addQuads(ModelState modelState, ResourceLocation modelLocation, TextureAtlasSprite trimSprite, CompositeModel.Baked.Builder builder, RenderTypeGroup normalRenderTypes, @Nullable Transformation transformation) {
        ModelState transformedState = transformation == null ? modelState : new SimpleModelState(modelState.m_6189_().m_121096_(transformation), modelState.m_7538_());
        List unbaked = UnbakedGeometryHelper.createUnbakedItemElements((int)0, (SpriteContents)trimSprite.m_245424_());
        List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, material -> trimSprite, (ModelState)transformedState, (ResourceLocation)modelLocation);
        builder.addQuads(normalRenderTypes, (Collection)quads);
    }

    private static final class TrimOverrideHandler
    extends ItemOverrides {
        private final Map<String, BakedModel> cache = Maps.newHashMap();
        private final ItemOverrides nested;
        private final ModelBaker baker;
        private final IGeometryBakingContext owner;
        private final TrimmedItemModel parent;

        private TrimOverrideHandler(ItemOverrides nested, ModelBaker baker, IGeometryBakingContext owner, TrimmedItemModel parent) {
            this.nested = nested;
            this.baker = baker;
            this.owner = owner;
            this.parent = parent;
        }

        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
            BakedModel overridden = this.nested.m_173464_(originalModel, stack, level, entity, seed);
            if (overridden != originalModel || level == null) {
                return overridden;
            }
            return ArmorTrim.m_266285_((RegistryAccess)level.m_9598_(), (ItemStack)stack).map(trim -> {
                String name = ((TrimMaterial)trim.m_266210_().get()).f_265854_();
                if (!this.cache.containsKey(name)) {
                    TrimmedItemModel unbaked = new TrimmedItemModel((ArmorTrim)trim);
                    BakedModel bakedModel = unbaked.bake(this.owner, this.baker, Material::m_119204_, (ModelState)BlockModelRotation.X0_Y0, this, Helpers.resourceLocation("forge", "bucket_override"));
                    this.cache.put(name, bakedModel);
                    return bakedModel;
                }
                return this.cache.get(name);
            }).orElse(originalModel);
        }
    }

    public static class Loader
    implements IGeometryLoader<TrimmedItemModel> {
        public TrimmedItemModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
            return new TrimmedItemModel(null);
        }
    }
}

