/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.math.Transformation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.CompositeModel;
import net.minecraftforge.client.model.DynamicFluidContainerModel;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.geometry.StandaloneGeometryBakingContext;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class ContainedFluidModel
implements IUnbakedGeometry<ContainedFluidModel> {
    public static final Transformation FLUID_TRANSFORM = new Transformation(new Vector3f(), new Quaternionf(), new Vector3f(1.004f, 1.004f, 1.002f), new Quaternionf());
    public static final Transformation COVER_TRANSFORM = new Transformation(new Vector3f(), new Quaternionf(), new Vector3f(1.0f, 1.0f, 1.004f), new Quaternionf());
    private final Fluid fluid;

    public ContainedFluidModel(Fluid fluid) {
        this.fluid = fluid;
    }

    public ContainedFluidModel withFluid(Fluid newFluid) {
        return new ContainedFluidModel(newFluid);
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        TextureAtlasSprite templateSprite;
        TextureAtlasSprite particleSprite;
        Material particleLocation = context.hasMaterial("particle") ? context.getMaterial("particle") : null;
        Material baseLocation = context.hasMaterial("base") ? context.getMaterial("base") : null;
        Material fluidMaskLocation = context.hasMaterial("fluid") ? context.getMaterial("fluid") : null;
        Material coverLocation = context.hasMaterial("cover") ? context.getMaterial("cover") : null;
        TextureAtlasSprite baseSprite = baseLocation != null ? spriteGetter.apply(baseLocation) : null;
        TextureAtlasSprite fluidSprite = this.fluid != Fluids.f_76191_ ? spriteGetter.apply(new Material(RenderHelpers.BLOCKS_ATLAS, IClientFluidTypeExtensions.of((Fluid)this.fluid).getStillTexture())) : null;
        TextureAtlasSprite coverSprite = coverLocation != null && baseLocation != null ? spriteGetter.apply(coverLocation) : null;
        TextureAtlasSprite textureAtlasSprite = particleSprite = particleLocation != null ? spriteGetter.apply(particleLocation) : null;
        if (particleSprite == null) {
            TextureAtlasSprite textureAtlasSprite2 = particleSprite = fluidSprite == null ? spriteGetter.apply(new Material(RenderHelpers.BLOCKS_ATLAS, Helpers.identifier("block/empty"))) : fluidSprite;
        }
        if (this.fluid != Fluids.f_76191_ && this.fluid.getFluidType().isLighterThanAir()) {
            modelState = new SimpleModelState(modelState.m_6189_().m_121096_(new Transformation(null, new Quaternionf(0.0f, 0.0f, 1.0f, 0.0f), null, null)));
        }
        StandaloneGeometryBakingContext itemContext = StandaloneGeometryBakingContext.builder((IGeometryBakingContext)context).withGui3d(false).withUseBlockLight(false).build(modelLocation);
        CompositeModel.Baked.Builder builder = CompositeModel.Baked.builder((IGeometryBakingContext)itemContext, (TextureAtlasSprite)particleSprite, (ItemOverrides)new ContainedFluidOverrideHandler(overrides, bakery, (IGeometryBakingContext)itemContext, this), (ItemTransforms)context.getTransforms());
        RenderTypeGroup normalRenderTypes = DynamicFluidContainerModel.getLayerRenderTypes((boolean)false);
        if (baseLocation != null) {
            List unbaked = UnbakedGeometryHelper.createUnbakedItemElements((int)0, (SpriteContents)baseSprite.m_245424_());
            List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> baseSprite, (ModelState)modelState, (ResourceLocation)modelLocation);
            builder.addQuads(normalRenderTypes, (Collection)quads);
        }
        if (fluidMaskLocation != null && fluidSprite != null && (templateSprite = spriteGetter.apply(fluidMaskLocation)) != null) {
            SimpleModelState transformedState = new SimpleModelState(modelState.m_6189_().m_121096_(FLUID_TRANSFORM), modelState.m_7538_());
            List unbaked = UnbakedGeometryHelper.createUnbakedItemMaskElements((int)1, (SpriteContents)templateSprite.m_245424_());
            List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> fluidSprite, (ModelState)transformedState, (ResourceLocation)modelLocation);
            boolean emissive = this.fluid.getFluidType().getLightLevel() > 0;
            RenderTypeGroup renderTypes = DynamicFluidContainerModel.getLayerRenderTypes((boolean)emissive);
            if (emissive) {
                QuadTransformers.settingMaxEmissivity().processInPlace(quads);
            }
            builder.addQuads(renderTypes, (Collection)quads);
        }
        if (coverSprite != null) {
            SimpleModelState transformedState = new SimpleModelState(modelState.m_6189_().m_121096_(COVER_TRANSFORM), modelState.m_7538_());
            List unbaked = UnbakedGeometryHelper.createUnbakedItemMaskElements((int)2, (SpriteContents)coverSprite.m_245424_());
            List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> baseSprite, (ModelState)transformedState, (ResourceLocation)modelLocation);
            builder.addQuads(normalRenderTypes, (Collection)quads);
        }
        builder.setParticle(particleSprite);
        return builder.build();
    }

    private static final class ContainedFluidOverrideHandler
    extends ItemOverrides {
        private final Map<String, BakedModel> cache = Maps.newHashMap();
        private final ItemOverrides nested;
        private final ModelBaker baker;
        private final IGeometryBakingContext owner;
        private final ContainedFluidModel parent;

        private ContainedFluidOverrideHandler(ItemOverrides nested, ModelBaker baker, IGeometryBakingContext owner, ContainedFluidModel parent) {
            this.nested = nested;
            this.baker = baker;
            this.owner = owner;
            this.parent = parent;
        }

        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
            BakedModel overridden = this.nested.m_173464_(originalModel, stack, level, entity, seed);
            if (overridden != originalModel) {
                return overridden;
            }
            return stack.getCapability(Capabilities.FLUID).map(cap -> {
                Fluid fluid = cap.getFluidInTank(0).getFluid();
                String name = Objects.requireNonNull(BuiltInRegistries.f_257020_.m_7981_((Object)fluid)).toString();
                if (!this.cache.containsKey(name)) {
                    ContainedFluidModel unbaked = this.parent.withFluid(fluid);
                    BakedModel bakedModel = unbaked.bake(this.owner, this.baker, Material::m_119204_, (ModelState)BlockModelRotation.X0_Y0, this, Helpers.resourceLocation("forge", "bucket_override"));
                    this.cache.put(name, bakedModel);
                    return bakedModel;
                }
                return this.cache.get(name);
            }).orElse(originalModel);
        }
    }

    public static class Colors
    implements ItemColor {
        public int m_92671_(@NotNull ItemStack stack, int tintIndex) {
            if (tintIndex != 1) {
                return -1;
            }
            return stack.getCapability(Capabilities.FLUID_ITEM).map(cap -> cap.getFluidInTank(0)).map(fluidStack -> IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getTintColor(fluidStack)).orElse(-1);
        }
    }

    public static class Loader
    implements IGeometryLoader<ContainedFluidModel> {
        public ContainedFluidModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
            return new ContainedFluidModel(Fluids.f_76191_);
        }
    }
}

