/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client;

import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.tracker.WorldTracker;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;

public enum ClimateRenderCache {
    INSTANCE;

    private long ticks;
    private float averageTemperature;
    private float temperature;
    private float rainfall;
    private Vec2 wind = Vec2.f_82462_;
    private float lastRainLevel;
    private float currRainLevel;

    public void onClientTick() {
        Level level = ClientHelpers.getLevel();
        Player player = ClientHelpers.getPlayer();
        if (level != null && player != null) {
            float f;
            BlockPos pos = player.m_20183_();
            this.ticks = Calendars.CLIENT.getTicks();
            this.averageTemperature = Climate.getAverageTemperature(level, pos);
            this.temperature = Climate.getTemperature(level, pos);
            this.rainfall = Climate.getRainfall(level, pos);
            this.wind = Climate.getWindVector(level, pos);
            if (level instanceof ClientLevel) {
                ClientLevel clientLevel = (ClientLevel)level;
                f = clientLevel.f_46438_;
            } else {
                f = 0.0f;
            }
            float targetRainLevel = f;
            float adjustedTargetRainLevel = WorldTracker.get(level).isRaining(level, pos) ? targetRainLevel : 0.0f;
            this.lastRainLevel = this.currRainLevel;
            if (this.currRainLevel < adjustedTargetRainLevel) {
                this.currRainLevel += 0.01f;
            } else if (this.currRainLevel > adjustedTargetRainLevel) {
                this.currRainLevel -= 0.01f;
            }
            this.currRainLevel = Mth.m_14036_((float)this.currRainLevel, (float)0.0f, (float)1.0f);
        }
    }

    public long getTicks() {
        return this.ticks;
    }

    public float getAverageTemperature() {
        return this.averageTemperature;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public float getRainfall() {
        return this.rainfall;
    }

    public float getRainLevel(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.lastRainLevel, (float)this.currRainLevel);
    }

    public Vec2 getWind() {
        return this.wind;
    }
}

