/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Objects;
import net.dries007.tfc.common.capabilities.egg.EggCapability;
import net.dries007.tfc.common.capabilities.egg.IEgg;
import net.dries007.tfc.common.capabilities.heat.Heat;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.capabilities.heat.IHeat;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.ChatFormatting;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class BarSystem {
    private static final BiMap<ResourceLocation, Bar> REGISTRY = HashBiMap.create();

    public static void registerDefaultBars() {
        BarSystem.register(Helpers.identifier("heat"), new Bar(){

            @Override
            public int getBarColor(ItemStack stack) {
                Heat heat;
                @Nullable IHeat cap = HeatCapability.get(stack);
                if (cap != null && cap.getTemperature() > 0.0f && (heat = Heat.getHeat(cap.getTemperature())) != null) {
                    return Objects.requireNonNull(heat.getColor().m_126665_());
                }
                return 0;
            }

            @Override
            public boolean isBarVisible(ItemStack stack) {
                return (Boolean)TFCConfig.CLIENT.displayItemHeatBars.get() != false && HeatCapability.isHot(stack);
            }

            @Override
            public int getBarWidth(ItemStack stack) {
                @Nullable IHeat cap = HeatCapability.get(stack);
                if (cap != null) {
                    HeatingRecipe recipe = HeatingRecipe.getRecipe(stack);
                    if (recipe != null) {
                        return Mth.m_14045_((int)Math.round(13.0f * cap.getTemperature() / recipe.getTemperature()), (int)1, (int)13);
                    }
                    return Mth.m_14045_((int)Math.round(13.0f * cap.getTemperature() / Heat.maxVisibleTemperature()), (int)1, (int)13);
                }
                return 0;
            }

            @Override
            public ItemStack createDefaultItem(ItemStack stack) {
                HeatCapability.setTemperature(stack, 0.0f);
                return stack;
            }
        });
        BarSystem.register(Helpers.identifier("egg"), new Bar(){

            @Override
            public int getBarColor(ItemStack stack) {
                return Objects.requireNonNull(ChatFormatting.GOLD.m_126665_());
            }

            @Override
            public boolean isBarVisible(ItemStack stack) {
                @Nullable IEgg egg = EggCapability.get(stack);
                return egg != null && egg.getHatchDay() != 0L;
            }

            @Override
            public int getBarWidth(ItemStack stack) {
                int maxDays = 8;
                @Nullable IEgg egg = EggCapability.get(stack);
                if (egg != null) {
                    int incubationDays = 8 - Mth.m_14045_((int)((int)(egg.getHatchDay() - Calendars.CLIENT.getTotalDays())), (int)0, (int)8);
                    return Math.round(13.0f * (float)incubationDays / 8.0f);
                }
                return 0;
            }

            @Override
            public ItemStack createDefaultItem(ItemStack stack) {
                @Nullable IEgg egg = EggCapability.get(stack);
                if (egg != null) {
                    egg.removeFertilization();
                }
                return stack;
            }
        });
    }

    public static synchronized Bar register(ResourceLocation id, Bar bar) {
        if (REGISTRY.containsKey((Object)id)) {
            throw new IllegalArgumentException("Duplicate key: " + id);
        }
        REGISTRY.put((Object)id, (Object)bar);
        return bar;
    }

    @Nullable
    public static Bar getCustomBar(ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        for (Bar bar : REGISTRY.values()) {
            if (!bar.isBarVisible(stack) || !bar.overridesOtherBars() && bar.createDefaultItem(stack.m_41777_()).m_150947_()) continue;
            return bar;
        }
        return null;
    }

    public static interface Bar {
        public int getBarColor(ItemStack var1);

        public boolean isBarVisible(ItemStack var1);

        public int getBarWidth(ItemStack var1);

        public ItemStack createDefaultItem(ItemStack var1);

        default public boolean overridesOtherBars() {
            return false;
        }
    }
}

