/*
 * Decompiled with CFR 0.152.
 */
package tfchotornot.common.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Map;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import tfchotornot.common.recipes.HONRecipeSerializers;

public class AdvancedDamageInputsShapedRecipe
extends ShapedRecipe {
    public final ItemStackProvider providerResult;
    public final int inputSlot;

    public AdvancedDamageInputsShapedRecipe(ResourceLocation id, String group, int width, int height, NonNullList<Ingredient> recipeItems, ItemStackProvider result, int inputSlot) {
        super(id, group, CraftingBookCategory.MISC, width, height, recipeItems, ItemStack.f_41583_);
        this.providerResult = result;
        this.inputSlot = inputSlot;
    }

    public static boolean isUnbreakable(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128471_("Unbreakable");
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList items = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < items.size(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41763_()) {
                items.set(i, (Object)Helpers.damageCraftingItem((ItemStack)stack, (int)1).m_41777_());
                continue;
            }
            if (AdvancedDamageInputsShapedRecipe.isUnbreakable(stack)) {
                items.set(i, (Object)stack.m_41777_());
                continue;
            }
            if (!stack.hasCraftingRemainingItem()) continue;
            items.set(i, (Object)stack.getCraftingRemainingItem());
        }
        return items;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.providerResult.getEmptyStack();
    }

    public ItemStack m_5874_(CraftingContainer inventory, RegistryAccess registryAccess) {
        RecipeHelpers.setCraftingInput((CraftingContainer)inventory);
        int matchSlot = RecipeHelpers.translateMatch((ShapedRecipe)this, (int)this.inputSlot, (CraftingContainer)inventory);
        ItemStack inputStack = matchSlot != -1 ? inventory.m_8020_(matchSlot).m_41777_() : ItemStack.f_41583_;
        ItemStack result = this.providerResult.getSingleStack(inputStack);
        RecipeHelpers.clearCraftingInput();
        return result;
    }

    public boolean m_5598_() {
        return this.providerResult.dependsOnInput();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)HONRecipeSerializers.ADVANCED_DAMAGE_INPUTS_SHAPED_CRAFTING.get();
    }

    public static class Serializer
    extends RecipeSerializerImpl<AdvancedDamageInputsShapedRecipe> {
        public AdvancedDamageInputsShapedRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            Map keys = RecipeHelpers.keyFromJson((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            String[] pattern = RecipeHelpers.shrink((String[])RecipeHelpers.patternFromJson((JsonArray)GsonHelper.m_13933_((JsonObject)json, (String)"pattern")));
            int width = pattern[0].length();
            int height = pattern.length;
            NonNullList recipeItems = RecipeHelpers.dissolvePattern((String[])pattern, (Map)keys, (int)width, (int)height);
            ItemStackProvider providerResult = ItemStackProvider.fromJson((JsonObject)JsonHelpers.m_13930_((JsonObject)json, (String)"result"));
            int inputRow = JsonHelpers.m_13927_((JsonObject)json, (String)"input_row");
            int inputCol = JsonHelpers.m_13927_((JsonObject)json, (String)"input_column");
            if (inputRow < 0 || inputRow >= width) {
                throw new JsonParseException("input_row must be in the range [0, width)");
            }
            if (inputCol < 0 || inputCol >= height) {
                throw new JsonParseException("input_column must be in the range [0, height)");
            }
            int inputSlot = RecipeHelpers.dissolveRowColumn((int)inputRow, (int)inputCol, (int)width);
            return new AdvancedDamageInputsShapedRecipe(recipeId, group, width, height, (NonNullList<Ingredient>)recipeItems, providerResult, inputSlot);
        }

        public AdvancedDamageInputsShapedRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int width = buffer.m_130242_();
            int height = buffer.m_130242_();
            String group = buffer.m_130277_();
            NonNullList recipeItems = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
            for (int k = 0; k < recipeItems.size(); ++k) {
                recipeItems.set(k, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStackProvider provider = ItemStackProvider.fromNetwork((FriendlyByteBuf)buffer);
            int inputSlot = buffer.m_130242_();
            return new AdvancedDamageInputsShapedRecipe(recipeId, group, width, height, (NonNullList<Ingredient>)recipeItems, provider, inputSlot);
        }

        public void toNetwork(FriendlyByteBuf buffer, AdvancedDamageInputsShapedRecipe recipe) {
            buffer.m_130130_(recipe.m_44220_());
            buffer.m_130130_(recipe.m_44221_());
            buffer.m_130070_(recipe.m_6076_());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            recipe.providerResult.toNetwork(buffer);
            buffer.m_130130_(recipe.inputSlot);
        }
    }
}

