/*
 * Decompiled with CFR 0.152.
 */
package tfchotornot;

import java.util.function.Function;
import net.dries007.tfc.util.Helpers;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final Config COMMON = Config.register(ModConfig.Type.COMMON, Config::new);
    public final ForgeConfigSpec.BooleanValue enableTooltips;
    public final ForgeConfigSpec.BooleanValue enableGaseous;
    public final ForgeConfigSpec.BooleanValue toggleFluidPuddle;
    public final ForgeConfigSpec.BooleanValue yeet;
    public final ForgeConfigSpec.IntValue hotTemperature;
    public final ForgeConfigSpec.IntValue coldTemperature;
    public final ForgeConfigSpec.IntValue hotFluidTemperature;
    public final ForgeConfigSpec.IntValue coldFluidTemperature;
    public final ForgeConfigSpec.DoubleValue itemTemperatureModifier;
    public final ForgeConfigSpec.IntValue itemHeatTimeInterval;
    public final ForgeConfigSpec.IntValue itemDamageTimeInterval;
    public final ForgeConfigSpec.IntValue woodenTongsDurability;
    public final ForgeConfigSpec.IntValue potholderDurability;
    public final ForgeConfigSpec.IntValue mittenDurability;

    public static void init() {
    }

    private static <C> C register(ModConfig.Type type, Function<ForgeConfigSpec.Builder, C> factory) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(factory);
        if (!Helpers.BOOTSTRAP_ENVIRONMENT) {
            ModLoadingContext.get().registerConfig(type, (IConfigSpec)specPair.getRight());
        }
        return (C)specPair.getLeft();
    }

    Config(ForgeConfigSpec.Builder innerBuilder) {
        Function<String, ForgeConfigSpec.Builder> builder = name -> innerBuilder.translation("tfchotornot.config.common." + name);
        innerBuilder.push("general");
        this.enableTooltips = builder.apply("enableTooltips").comment("This sets whether an item that contains a fluid will have a tooltip that they are gaseous, too hot or too cold.").define("enableTooltips", true);
        this.enableGaseous = builder.apply("enableGaseous").comment("This sets whether gaseous effect for a fluid should be enabled.").define("enableGaseous", true);
        this.toggleFluidPuddle = builder.apply("toggleFluidPuddle").comment("If true, then items that melt into a fluid will create a puddle below you. Potentially dangerous if this is a molten metal, lava or equivalent.").define("toggleFluidPuddle", true);
        this.yeet = builder.apply("yeet").comment("If true, players yeet hot or cold items from their hands.").define("yeet", true);
        this.hotTemperature = builder.apply("hotTemperature").comment("This sets the temperature when a hot object should start burning the player (in celsius).").defineInRange("hotTemperature", 300, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.coldTemperature = builder.apply("coldTemperature").comment("This sets the temperature when a cold object should add effects to the player (in celsius).").defineInRange("coldTemperature", -20, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.hotFluidTemperature = builder.apply("hotFluidTemperature").comment("This sets the temperature when a hot fluid should start burning the player (in kelvin).").defineInRange("hotFluidTemperature", 1300, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.coldFluidTemperature = builder.apply("coldFluidTemperature").comment("This sets the temperature when a cold fluid should add effects to the player (in kelvin).").defineInRange("coldFluidTemperature", 273, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.itemTemperatureModifier = builder.apply("itemTemperatureModifier").comment("Modifier for how much the offhand item should heat up when holding hot items. Holding multiple hot items will heat your insulating items faster!").defineInRange("itemTemperatureModifier", 2.0, Double.MIN_VALUE, Double.MAX_VALUE);
        this.itemHeatTimeInterval = builder.apply("itemHeatTimeInterval").comment("How often the heat of your tongs, mittens or potholders should increase. Higher value -> slower. Too high and items won't heat up.").defineInRange("itemHeatTimeInterval", 1, 1, Integer.MAX_VALUE);
        this.itemDamageTimeInterval = builder.apply("itemDamageTimeInterval").comment("How often the durability of your tongs, mittens or potholders should take damage. Higher value -> slower. Holding multiple hot items will damage your insulating items faster!").defineInRange("itemDamageTimeInterval", 10, 1, Integer.MAX_VALUE);
        this.woodenTongsDurability = builder.apply("woodenTongsDurability").comment("Durability for wooden tongs.").defineInRange("woodenTongsDurability", 200, 0, Integer.MAX_VALUE);
        this.potholderDurability = builder.apply("potholderDurability").comment("Durability for potholders.").defineInRange("potholderDurability", 800, 0, Integer.MAX_VALUE);
        this.mittenDurability = builder.apply("mittenDurability").comment("Durability for mittens.").defineInRange("mittenDurability", 1700, 0, Integer.MAX_VALUE);
    }
}

