/*
 * Decompiled with CFR 0.152.
 */
package tfchotornot;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.capabilities.heat.IHeat;
import net.dries007.tfc.util.Helpers;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import tfchotornot.Config;
import tfchotornot.EventHandler;
import tfchotornot.common.HNTags;

public class ClientEventHandler {
    public static final String TOOLTIP_INSULATING_ITEMS = "tooltip.tfchotornot.insulating_items";

    public static void init() {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addListener(EventPriority.HIGHEST, ClientEventHandler::onTooltip);
    }

    public static void onTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (((Boolean)Config.COMMON.enableTooltips.get()).booleanValue() && !stack.m_41619_()) {
            if (Helpers.isItem((Item)stack.m_41720_(), HNTags.Items.INSULATING)) {
                event.getToolTip().add(Component.m_237115_((String)TOOLTIP_INSULATING_ITEMS).m_130940_(ChatFormatting.GREEN));
            }
            if (event.getEntity() != null) {
                if (stack == event.getEntity().m_21206_() && !Helpers.isItem((ItemStack)stack, HNTags.Items.INSULATING)) {
                    ClientEventHandler.addToolTips(stack, event);
                } else if (stack != event.getEntity().m_21206_()) {
                    ClientEventHandler.addToolTips(stack, event);
                }
            }
        }
    }

    public static void addToolTips(ItemStack stack, ItemTooltipEvent event) {
        boolean isGlassWorkingTool;
        TagKey glassworkingTool = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)Helpers.identifier((String)"glassworking_tools"));
        boolean bl = isGlassWorkingTool = Helpers.isItem((ItemStack)stack, (TagKey)TFCTags.Items.ALL_BLOWPIPES) || Helpers.isItem((ItemStack)stack, (TagKey)glassworkingTool);
        if (isGlassWorkingTool) {
            return;
        }
        if (stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()) {
            LazyOptional iFluidHandler = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
            iFluidHandler.ifPresent(h -> {
                FluidStack fluidStack = h.drain(1000, IFluidHandler.FluidAction.SIMULATE);
                if (fluidStack != FluidStack.EMPTY && Helpers.isFluid((Fluid)fluidStack.getFluid(), HNTags.Fluids.FLUID_WHITELIST)) {
                    if (Helpers.isFluid((Fluid)fluidStack.getFluid(), HNTags.Fluids.COLD_WHITELIST) || fluidStack.getFluid().getFluidType().getTemperature(fluidStack) <= (Integer)Config.COMMON.coldFluidTemperature.get()) {
                        event.getToolTip().add(EventHandler.FluidEffect.COLD.tooltip);
                    }
                    if (Helpers.isFluid((Fluid)fluidStack.getFluid(), HNTags.Fluids.GASEOUS_WHITELIST) || Helpers.isItem((Item)stack.m_41720_(), HNTags.Items.GASEOUS_WHITELIST) && ((Boolean)Config.COMMON.enableGaseous.get()).booleanValue()) {
                        event.getToolTip().add(EventHandler.FluidEffect.GAS.tooltip);
                    }
                    if (Helpers.isFluid((Fluid)fluidStack.getFluid(), HNTags.Fluids.HOT_WHITELIST) || fluidStack.getFluid().getFluidType().getTemperature(fluidStack) >= (Integer)Config.COMMON.hotFluidTemperature.get()) {
                        event.getToolTip().add(EventHandler.FluidEffect.HOT.tooltip);
                    }
                }
            });
        } else if (HeatCapability.has((ItemStack)stack)) {
            IHeat heat = HeatCapability.get((ItemStack)stack);
            if (Helpers.isItem((Item)stack.m_41720_(), HNTags.Items.HOT_WHITELIST) || heat.getTemperature() >= (float)((Integer)Config.COMMON.hotTemperature.get()).intValue()) {
                event.getToolTip().add(EventHandler.FluidEffect.HOT.tooltip);
            }
            if (Helpers.isItem((Item)stack.m_41720_(), HNTags.Items.COLD_WHITELIST) || heat.getTemperature() <= (float)((Integer)Config.COMMON.coldTemperature.get()).intValue()) {
                event.getToolTip().add(EventHandler.FluidEffect.COLD.tooltip);
            }
            if (Helpers.isItem((Item)stack.m_41720_(), HNTags.Items.GASEOUS_WHITELIST) && ((Boolean)Config.COMMON.enableGaseous.get()).booleanValue()) {
                event.getToolTip().add(EventHandler.FluidEffect.GAS.tooltip);
            }
        } else {
            if (Helpers.isItem((Item)stack.m_41720_(), HNTags.Items.HOT_WHITELIST)) {
                event.getToolTip().add(EventHandler.FluidEffect.HOT.tooltip);
            }
            if (Helpers.isItem((Item)stack.m_41720_(), HNTags.Items.COLD_WHITELIST)) {
                event.getToolTip().add(EventHandler.FluidEffect.COLD.tooltip);
            }
            if (Helpers.isItem((Item)stack.m_41720_(), HNTags.Items.GASEOUS_WHITELIST) && ((Boolean)Config.COMMON.enableGaseous.get()).booleanValue()) {
                event.getToolTip().add(EventHandler.FluidEffect.GAS.tooltip);
            }
        }
    }
}

