/*
 * Decompiled with CFR 0.152.
 */
package tfcdesirepaths.common.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.dries007.tfc.common.blocks.SnowPileBlock;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.common.recipes.IBlockRecipe;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.ingredients.BlockIngredient;
import net.dries007.tfc.common.recipes.inventory.BlockInventory;
import net.dries007.tfc.util.JsonHelpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.dries007.tfc.world.chunkdata.ChunkDataProvider;
import net.dries007.tfc.world.settings.RockSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import tfcdesirepaths.Config;
import tfcdesirepaths.common.recipes.DPRecipeSerializers;
import tfcdesirepaths.common.recipes.DPRecipeTypes;

public class CompactionRecipe
implements IBlockRecipe {
    public static final IndirectHashCollection<Block, CompactionRecipe> CACHE = IndirectHashCollection.createForRecipe(recipe -> recipe.getBlockIngredient().blocks(), DPRecipeTypes.COMPACT);
    public final ResourceLocation id;
    public final BlockIngredient ingredient;
    public final BlockState outputState;
    public final boolean mud;
    public final int chance;
    public final int chanceFactor;
    public final Rock.BlockType rockBlockType;
    public final boolean rock;
    public final boolean snow;

    CompactionRecipe(ResourceLocation id, BlockIngredient ingredient, BlockState outputState, boolean mud, int chance, int chanceFactor, Rock.BlockType rockBlockType, boolean rock, boolean snow) {
        this.id = id;
        this.ingredient = ingredient;
        this.outputState = outputState;
        this.mud = mud;
        this.chance = chance;
        this.chanceFactor = chanceFactor;
        this.rockBlockType = rockBlockType;
        this.rock = rock;
        this.snow = snow;
    }

    @Nullable
    public static CompactionRecipe getRecipe(Level world, BlockInventory wrapper) {
        for (CompactionRecipe recipe : CACHE.getAll((Object)wrapper.getState().m_60734_())) {
            if (!recipe.matches(wrapper, world)) continue;
            return recipe;
        }
        return null;
    }

    public static boolean compactBlock(Level level, BlockPos pos, BlockState state, double chance) {
        BlockInventory wrapper = new BlockInventory(pos, state);
        CompactionRecipe recipe = CompactionRecipe.getRecipe(level, wrapper);
        if (recipe.isRock() && !((Boolean)Config.COMMON.toggleRockBlocks.get()).booleanValue()) {
            return false;
        }
        if (!level.m_5776_() && recipe != null && level.m_213780_().m_188503_(1 + Mth.m_14107_((double)chance)) == 0) {
            RockSettings rock;
            ServerLevel server;
            if (recipe.isSnow()) {
                SnowPileBlock.removePileOrSnow((LevelAccessor)level, (BlockPos)pos, (BlockState)state, (int)((Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_) - 1));
                return true;
            }
            if (recipe.getRockBlockType() != null && recipe.getRockBlockType() != Rock.BlockType.AQUEDUCT && level instanceof ServerLevel && ChunkDataProvider.get((WorldGenLevel)(server = (ServerLevel)level)) != null && (rock = ChunkDataProvider.get((WorldGenLevel)server).get((WorldGenLevel)server, pos).getRockData().getRock(pos)) != null && recipe.getBlockType(rock) != null) {
                BlockState compactState = recipe.getBlockType(rock).m_49966_();
                level.m_46597_(pos, compactState);
                return true;
            }
            if (recipe.isMud() && level.m_46758_(pos) || !recipe.isMud()) {
                BlockState compactState = recipe.getBlockCraftingResult(wrapper);
                level.m_46597_(pos, compactState);
                return true;
            }
        }
        return false;
    }

    public Block getBlockType(RockSettings rock) {
        if (this.getRockBlockType() != null) {
            switch (this.getRockBlockType()) {
                case RAW: {
                    return rock.raw();
                }
                case HARDENED: {
                    return rock.hardened();
                }
                case COBBLE: {
                    return rock.cobble();
                }
                case GRAVEL: {
                    return rock.gravel();
                }
            }
            return rock.gravel();
        }
        return null;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)DPRecipeSerializers.COMPACT.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)DPRecipeTypes.COMPACT.get();
    }

    public boolean matches(BlockState state) {
        return this.ingredient.test(state);
    }

    public BlockState getBlockCraftingResult(BlockState state) {
        return this.outputState;
    }

    public Block getBlockRecipeOutput() {
        return this.outputState.m_60734_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public BlockIngredient getBlockIngredient() {
        return this.ingredient;
    }

    public boolean isMud() {
        return this.mud;
    }

    public int getChance() {
        return this.chance;
    }

    public int getChanceFactor() {
        return this.chanceFactor;
    }

    public Rock.BlockType getRockBlockType() {
        return this.rockBlockType;
    }

    public boolean isRock() {
        return this.rock;
    }

    public boolean isSnow() {
        return this.snow;
    }

    public static class Serializer
    extends RecipeSerializerImpl<CompactionRecipe> {
        public CompactionRecipe fromJson(ResourceLocation id, JsonObject json) {
            BlockIngredient ingredient = BlockIngredient.fromJson((JsonElement)JsonHelpers.get((JsonObject)json, (String)"ingredient"));
            BlockState state = JsonHelpers.getBlockState((String)GsonHelper.m_13906_((JsonObject)json, (String)"result"));
            boolean mud = GsonHelper.m_13855_((JsonObject)json, (String)"mud", (boolean)false);
            int chance = GsonHelper.m_13824_((JsonObject)json, (String)"chance", (int)0);
            int chanceFactor = GsonHelper.m_13824_((JsonObject)json, (String)"chance_factor", (int)0);
            Rock.BlockType rockBlockType = (Rock.BlockType)JsonHelpers.getEnum((JsonObject)json, (String)"rock_block_type", Rock.BlockType.class, (Enum)Rock.BlockType.AQUEDUCT);
            boolean rock = GsonHelper.m_13855_((JsonObject)json, (String)"rock", (boolean)false);
            boolean snow = GsonHelper.m_13855_((JsonObject)json, (String)"is_snow", (boolean)false);
            return new CompactionRecipe(id, ingredient, state, mud, chance, chanceFactor, rockBlockType, rock, snow);
        }

        @Nullable
        public CompactionRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            BlockIngredient ingredient = BlockIngredient.fromNetwork((FriendlyByteBuf)buffer);
            BlockState state = ((Block)buffer.readRegistryIdUnsafe(ForgeRegistries.BLOCKS)).m_49966_();
            boolean mud = buffer.readBoolean();
            int chance = buffer.readInt();
            int chanceFactor = buffer.readInt();
            Rock.BlockType rockBlockType = (Rock.BlockType)buffer.m_130066_(Rock.BlockType.class);
            boolean rock = buffer.readBoolean();
            boolean snow = buffer.readBoolean();
            return new CompactionRecipe(id, ingredient, state, mud, chance, chanceFactor, rockBlockType, rock, snow);
        }

        public void toNetwork(FriendlyByteBuf buffer, CompactionRecipe recipe) {
            recipe.ingredient.toNetwork(buffer);
            buffer.writeRegistryIdUnsafe(ForgeRegistries.BLOCKS, (Object)recipe.outputState.m_60734_());
            buffer.writeBoolean(recipe.mud);
            buffer.writeInt(recipe.chance);
            buffer.writeInt(recipe.chanceFactor);
            buffer.m_130068_((Enum)recipe.rockBlockType);
            buffer.writeBoolean(recipe.rock);
            buffer.writeBoolean(recipe.snow);
        }
    }
}

