/*
 * Decompiled with CFR 0.152.
 */
package tfccaelum.shaders.aurora;

import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
final class Panel {
    public static final double COS_DEG90_FACTOR = Math.cos(1.5707963267948966);
    public static final double COS_DEG270_FACTOR = Math.cos(4.71238898038469);
    public static final double SIN_DEG90_FACTOR = Math.sin(1.5707963267948966);
    public double dZ = 0.0;
    public double dY = 0.0;
    public double sinDeg90 = 0.0;
    public final double posX;
    public final double posY;
    public final double posZ;
    public double tetX = 0.0;
    public double tetX2 = 0.0;
    public double tetZ = 0.0;

    public Panel(double x, double y, double z) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
    }

    public void translate(double dY, double dZ) {
        this.dZ = dZ;
        this.dY = dY;
        double mZ = this.getModdedZ();
        this.tetZ = mZ + this.sinDeg90;
    }

    public double getModdedZ() {
        return this.posZ + this.dZ;
    }

    public double getModdedY() {
        double y = this.posY + this.dY;
        return Math.max(0.0, y);
    }

    public void setWidth(double w) {
        double cosDeg270 = COS_DEG270_FACTOR * w;
        double cosDeg90 = COS_DEG90_FACTOR * w;
        this.sinDeg90 = SIN_DEG90_FACTOR * w;
        this.tetX = this.posX + cosDeg90;
        this.tetX2 = this.posX + cosDeg270;
    }
}

