/*
 * Decompiled with CFR 0.152.
 */
package tfccaelum.shaders.aurora;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import tfccaelum.shaders.ShaderCallContext;
import tfccaelum.shaders.ShaderPrograms;
import tfccaelum.shaders.aurora.AuroraBase;
import tfccaelum.shaders.aurora.AuroraRenderType;
import tfccaelum.shaders.aurora.AuroraUtils;

@OnlyIn(value=Dist.CLIENT)
public class AuroraShaderBand
extends AuroraBase {
    public static final float V1 = 0.0f;
    public static final float V2 = 0.5f;
    public ShaderPrograms program = ShaderPrograms.AURORA;
    public Consumer<ShaderCallContext> callback = shaderCallContext -> {
        shaderCallContext.set("time", AuroraUtils.getTimeSeconds() * 0.75f);
        shaderCallContext.set("resolution", this.getAuroraWidth(), this.getAuroraHeight());
        shaderCallContext.set("topColor", this.getFadeColor());
        shaderCallContext.set("middleColor", this.getMiddleColor());
        shaderCallContext.set("bottomColor", this.getBaseColor());
        shaderCallContext.set("alpha", this.getAlpha());
    };
    public final float auroraWidth = (float)((double)this.band.getPanelCount() * this.band.getNodeWidth());
    public final float panelTexWidth = (float)(this.band.getNodeWidth() / (double)this.auroraWidth);

    public AuroraShaderBand(long seed) {
        super(seed);
    }

    @Override
    public void update() {
        super.update();
        this.band.update();
    }

    @Override
    public double getAlpha() {
        return Mth.m_14008_((double)((double)((float)this.band.getAlphaLimit() / 255.0f) * this.tracker.ageRatio() * 2.0), (double)0.0, (double)1.0);
    }

    public double getAuroraWidth() {
        return this.auroraWidth;
    }

    public double getAuroraHeight() {
        return 180.0;
    }

    public void generateBand(@Nonnull VertexConsumer builder, @Nonnull Matrix4f matrix) {
        Vector3f[] quad;
        int i = 0;
        while ((quad = this.band.getPanelQuad(i)) != null) {
            float u1 = (float)i * this.panelTexWidth;
            float u2 = u1 + this.panelTexWidth;
            builder.m_252986_(matrix, quad[0].x(), quad[0].y(), quad[0].z()).m_7421_(u1, 0.0f).m_5752_();
            builder.m_252986_(matrix, quad[1].x(), quad[1].y(), quad[1].z()).m_7421_(u2, 0.0f).m_5752_();
            builder.m_252986_(matrix, quad[2].x(), quad[2].y(), quad[2].z()).m_7421_(u2, 0.5f).m_5752_();
            builder.m_252986_(matrix, quad[3].x(), quad[3].y(), quad[3].z()).m_7421_(u1, 0.5f).m_5752_();
            ++i;
        }
    }

    @Override
    public void render(LevelAccessor level, @Nonnull PoseStack matrixStack, double partialTick) {
        if (this.program == null) {
            return;
        }
        this.band.translate(partialTick);
        double tranY = this.getTranslationY(level, partialTick);
        double tranX = this.getTranslationX(partialTick);
        double tranZ = this.getTranslationZ(partialTick);
        Vec3 view = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(-view.m_7096_(), -view.m_7098_(), -view.m_7094_());
        RenderType type = AuroraRenderType.QUAD;
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        ShaderPrograms.MANAGER.useShader(this.program, this.callback);
        try {
            for (int b = 0; b < this.bandCount; ++b) {
                VertexConsumer builder = buffer.m_6299_(type);
                matrixStack.m_85836_();
                matrixStack.m_85837_(tranX, tranY, tranZ + this.offset * (double)b);
                this.generateBand(builder, matrixStack.m_85850_().m_252922_());
                matrixStack.m_85849_();
                RenderSystem.disableDepthTest();
                buffer.m_109912_(type);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.program = null;
        }
        ShaderPrograms.MANAGER.releaseShader();
        matrixStack.m_85849_();
    }

    @Override
    public String toString() {
        return "<SHADER> " + super.toString();
    }
}

