/*
 * Decompiled with CFR 0.152.
 */
package tfccaelum.shaders.aurora;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import tfccaelum.shaders.aurora.AuroraFactory;
import tfccaelum.shaders.aurora.Panel;

@OnlyIn(value=Dist.CLIENT)
public class AuroraBand {
    public static final double AURORA_SPEED = 0.75;
    public static final double AURORA_WAVELENGTH = 18.0;
    public static final double AURORA_AMPLITUDE = 180.0;
    public final Random random;
    public Panel[] nodes;
    public double cycle = 0.0;
    public int alphaLimit = 128;
    public int length;
    public double nodeLength;
    public double nodeWidth;

    public AuroraBand(Random random, AuroraFactory.AuroraGeometry geo) {
        this.random = random;
        this.preset(geo);
        this.generateBands();
        this.translate(0.0);
    }

    public int getAlphaLimit() {
        return this.alphaLimit;
    }

    public double getNodeWidth() {
        return this.nodeWidth;
    }

    public int getPanelCount() {
        return this.nodes.length - 1;
    }

    @Nullable
    public Vector3f[] getPanelQuad(int panelNumber) {
        if (panelNumber < 0 || panelNumber >= this.getPanelCount()) {
            return null;
        }
        Vector3f[] nodes = new Vector3f[4];
        Panel panelA = this.nodes[panelNumber];
        Panel panelB = this.nodes[panelNumber + 1];
        nodes[0] = new Vec3(panelA.tetX, 0.0, panelA.tetZ).m_252839_();
        nodes[1] = new Vec3(panelB.tetX, 0.0, panelB.tetZ).m_252839_();
        nodes[2] = new Vec3(panelB.tetX, panelB.getModdedY(), panelB.tetZ).m_252839_();
        nodes[3] = new Vec3(panelA.tetX, panelA.getModdedY(), panelA.tetZ).m_252839_();
        return nodes;
    }

    public void update() {
        double d;
        this.cycle += 0.75;
        if (d >= 360.0) {
            this.cycle -= 360.0;
        }
    }

    public void translate(double partialTick) {
        double c = this.cycle + 0.75 * partialTick;
        for (int i = 0; i < this.nodes.length; ++i) {
            double f = Math.cos(Math.toRadians((double)(i << 3) + c));
            this.nodes[i].translate(f * 3.0, f * 18.0);
        }
    }

    public void preset(AuroraFactory.AuroraGeometry geo) {
        this.length = geo.length;
        this.nodeLength = geo.nodeLength;
        this.nodeWidth = geo.nodeWidth;
        this.alphaLimit = geo.alphaLimit;
    }

    public void generateBands() {
        this.nodes = this.populate();
        for (int i = 0; i < this.length; ++i) {
            this.nodes[i].setWidth(this.nodeWidth);
        }
    }

    @Nonnull
    public Panel[] populate() {
        double x;
        double z;
        double subAngleRads;
        double subAngle;
        Panel node;
        int idx;
        double angle;
        Panel[] nodeList = new Panel[this.length];
        double[] angles = new double[this.length];
        int bound = this.length / 2 - 1;
        double angleTotal = 0.0;
        for (int i = this.length / 8 / 2 - 1; i >= 0; --i) {
            angle = (this.random.nextFloat() - 0.5f) * 8.0f;
            if (Math.abs(angleTotal += angle) > 180.0) {
                angle = -angle;
                angleTotal += angle;
            }
            for (int k = 7; k >= 0; --k) {
                idx = i * 8 + k;
                if (idx == bound) {
                    nodeList[idx] = new Panel(0.0, 180.0, 0.0);
                    angles[idx] = angle;
                    continue;
                }
                node = nodeList[idx + 1];
                subAngle = angles[idx + 1] + angle;
                subAngleRads = Math.toRadians(subAngle);
                z = node.posZ - Math.sin(subAngleRads) * this.nodeLength;
                x = node.posX - Math.cos(subAngleRads) * this.nodeLength;
                nodeList[idx] = new Panel(x, 180.0, z);
                angles[idx] = subAngle;
            }
        }
        angleTotal = 0.0;
        for (int j = this.length / 8 / 2; j < this.length / 8; ++j) {
            angle = (this.random.nextFloat() - 0.5f) * 8.0f;
            if (Math.abs(angleTotal += angle) > 180.0) {
                angle = -angle;
                angleTotal += angle;
            }
            for (int h = 0; h < 8; ++h) {
                idx = j * 8 + h - 1;
                node = nodeList[idx];
                subAngle = angles[idx] + angle;
                subAngleRads = Math.toRadians(subAngle);
                z = node.posZ + Math.sin(subAngleRads) * this.nodeLength;
                x = node.posX + Math.cos(subAngleRads) * this.nodeLength;
                nodeList[idx + 1] = new Panel(x, 180.0, z);
                angles[idx + 1] = subAngle;
            }
        }
        return nodeList;
    }
}

