/*
 * Decompiled with CFR 0.152.
 */
package com.tadashi.mixin;

import com.tadashi.Registry;
import java.util.function.Predicate;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.BlastFurnaceBlock;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.MultiBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlastFurnaceBlock.class})
public abstract class BlastFurnaceMixin {
    private static final MultiBlock BLAST_FURNACE_CHIMNEY = BlastFurnaceMixin.getBlastFurnaceChimney();
    private static final MultiBlock INSULATED_CHIMNEY;
    private static final Predicate<BlockState> IS_INSULATED;

    @Accessor(value="BLAST_FURNACE_CHIMNEY")
    private static MultiBlock getBlastFurnaceChimney() {
        throw new AssertionError();
    }

    @Inject(method={"getChimneyLevels"}, at={@At(value="HEAD")}, cancellable=true)
    private static void inject_getChimneyLevels(Level level, BlockPos pos, CallbackInfoReturnable<Integer> cir) {
        int maxHeight = (Integer)TFCConfig.SERVER.blastFurnaceMaxChimneyHeight.get();
        for (int i = 0; i < maxHeight; ++i) {
            BlockPos center = pos.m_6630_(i + 1);
            if (BLAST_FURNACE_CHIMNEY.test((LevelAccessor)level, center) || INSULATED_CHIMNEY.test((LevelAccessor)level, center)) continue;
            cir.setReturnValue((Object)i);
            return;
        }
        cir.setReturnValue((Object)maxHeight);
    }

    static {
        IS_INSULATED = b -> Helpers.isBlock((BlockState)b, (Block)((Block)Registry.INSULATED_FIRE_BRICKS.get()));
        INSULATED_CHIMNEY = new MultiBlock().match(new BlockPos(0, 0, 0), state -> state.m_60795_() || Helpers.isBlock((BlockState)state, (Block)((Block)TFCBlocks.MOLTEN.get()))).match(new BlockPos(0, 0, 1), IS_INSULATED).match(new BlockPos(0, 0, -1), IS_INSULATED).match(new BlockPos(1, 0, 0), IS_INSULATED).match(new BlockPos(-1, 0, 0), IS_INSULATED);
    }
}

