/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.common.entities;

import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistryWood;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import tfcastikorcarts.common.entities.carts.TFCAnimalCartEntity;
import tfcastikorcarts.common.entities.carts.TFCPlowEntity;
import tfcastikorcarts.common.entities.carts.TFCPostilionEntity;
import tfcastikorcarts.common.entities.carts.TFCSupplyCartEntity;
import tfcastikorcarts.common.items.AstikorItems;

public class AstikorEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"tfcastikorcarts");
    public static final Map<Wood, RegistryObject<EntityType<TFCSupplyCartEntity>>> SUPPLY_CART_TFC = Helpers.mapOfKeys(Wood.class, wood -> AstikorEntities.register("supply_cart/" + wood.name(), EntityType.Builder.m_20704_((type, level) -> new TFCSupplyCartEntity((EntityType<? extends Entity>)type, level, (Supplier)AstikorItems.SUPPLY_CART_TFC.get(wood)), (MobCategory)MobCategory.MISC).m_20699_(1.5f, 1.4f).m_20702_(10)));
    public static final Map<Wood, RegistryObject<EntityType<TFCPlowEntity>>> PLOW_TFC = Helpers.mapOfKeys(Wood.class, wood -> AstikorEntities.register("plow/" + wood.name(), EntityType.Builder.m_20704_((type, level) -> new TFCPlowEntity((EntityType<? extends Entity>)type, level, (Supplier)AstikorItems.PLOW_TFC.get(wood)), (MobCategory)MobCategory.MISC).m_20699_(1.3f, 1.4f).m_20702_(10)));
    public static final Map<Wood, RegistryObject<EntityType<TFCAnimalCartEntity>>> ANIMAL_CART_TFC = Helpers.mapOfKeys(Wood.class, wood -> AstikorEntities.register("animal_cart/" + wood.name(), EntityType.Builder.m_20704_((type, level) -> new TFCAnimalCartEntity((EntityType<? extends Entity>)type, level, (Supplier)AstikorItems.ANIMAL_CART_TFC.get(wood), (RegistryWood)wood), (MobCategory)MobCategory.MISC).m_20699_(1.3f, 1.4f).m_20702_(10)));
    public static final Map<Wood, RegistryObject<EntityType<TFCPostilionEntity>>> POSTILION_TFC = Helpers.mapOfKeys(Wood.class, wood -> AstikorEntities.register("postilion/" + wood.name(), EntityType.Builder.m_20704_((type, level) -> new TFCPostilionEntity((EntityType<? extends TFCPostilionEntity>)type, level, (Supplier)AstikorItems.POSTILION_TFC.get(wood)), (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20702_(10)));

    public static <E extends Entity> RegistryObject<EntityType<E>> register(String name, EntityType.Builder<E> builder) {
        return AstikorEntities.register(name, builder, true);
    }

    public static <E extends Entity> RegistryObject<EntityType<E>> register(String name, EntityType.Builder<E> builder, boolean serialize) {
        String id = name.toLowerCase(Locale.ROOT);
        return ENTITIES.register(id, () -> {
            if (!serialize) {
                builder.m_20716_();
            }
            return builder.m_20712_("tfcastikorcarts:" + id);
        });
    }

    public static void onEntityAttributeCreation(EntityAttributeCreationEvent event) {
        for (Wood wood : Wood.VALUES) {
            event.put((EntityType)POSTILION_TFC.get(wood).get(), LivingEntity.m_21183_().m_22265_());
        }
    }
}

