/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.common.container;

import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import tfcastikorcarts.common.container.ContainerTypes;
import tfcastikorcarts.util.AstikorHelpers;

public enum ContainerList {
    SIZE_0("1x1", 1, 1, 184, 184, 256, 256),
    SIZE_1("1x9", 1, 9, 184, 132, 256, 256),
    SIZE_2("2x9", 2, 9, 184, 150, 256, 256),
    SIZE_3("3x9", 3, 9, 184, 168, 256, 256),
    SIZE_4("4x9", 4, 9, 184, 186, 256, 256),
    SIZE_5("5x9", 5, 9, 184, 204, 256, 256),
    SIZE_6("6x9", 6, 9, 184, 222, 256, 256),
    SIZE_7("7x9", 7, 9, 184, 240, 256, 256),
    SIZE_8("8x9", 8, 9, 184, 258, 256, 276),
    SIZE_9("9x9", 9, 9, 184, 276, 256, 276),
    SIZE_10("9x10", 9, 10, 202, 276, 256, 276),
    SIZE_11("9x11", 9, 11, 220, 276, 256, 276),
    SIZE_12("9x12", 9, 12, 238, 276, 256, 276),
    SIZE_13("9x13", 9, 13, 256, 276, 256, 276);

    private static final ContainerList[] VALUES;
    public final String serializedName = this.name().toLowerCase(Locale.ROOT);
    public final String name;
    public final int size;
    public final int rows;
    public final int columns;
    public final int xSize;
    public final int ySize;
    public final ResourceLocation guiTexture;
    public final int textureXSize;
    public final int textureYSize;

    public static ContainerList valueOf(int i) {
        return i >= 0 && i < VALUES.length ? VALUES[i] : SIZE_1;
    }

    private ContainerList(String name, int rows, int columns, int xSize, int ySize, int textureXSize, int textureYSize) {
        this.name = name.toLowerCase(Locale.ROOT);
        this.rows = rows;
        this.columns = columns;
        this.size = rows * columns;
        this.xSize = xSize;
        this.ySize = ySize;
        this.guiTexture = AstikorHelpers.identifier("textures/gui/" + name.toLowerCase(Locale.ROOT) + ".png");
        this.textureXSize = textureXSize;
        this.textureYSize = textureYSize;
    }

    public String getName() {
        return this.name.toLowerCase(Locale.ROOT);
    }

    public String getSerializedName() {
        return this.serializedName.toLowerCase(Locale.ROOT);
    }

    public ResourceLocation getResourceLocation() {
        return this.guiTexture;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getSize() {
        return this.size;
    }

    public MenuType<?> getMenuType() {
        switch (this) {
            case SIZE_0: {
                return (MenuType)ContainerTypes.SUPPLY_CART_CONTAINER_SIZE_0.get();
            }
            case SIZE_1: {
                return (MenuType)ContainerTypes.SUPPLY_CART_CONTAINER_SIZE_1.get();
            }
            case SIZE_2: {
                return (MenuType)ContainerTypes.SUPPLY_CART_CONTAINER_SIZE_2.get();
            }
            case SIZE_3: {
                return (MenuType)ContainerTypes.SUPPLY_CART_CONTAINER_SIZE_3.get();
            }
            case SIZE_4: {
                return (MenuType)ContainerTypes.SUPPLY_CART_CONTAINER_SIZE_4.get();
            }
            case SIZE_5: {
                return (MenuType)ContainerTypes.SUPPLY_CART_CONTAINER_SIZE_5.get();
            }
            case SIZE_6: {
                return (MenuType)ContainerTypes.SUPPLY_CART_CONTAINER_SIZE_6.get();
            }
            case SIZE_7: {
                return (MenuType)ContainerTypes.SUPPLY_CART_CONTAINER_SIZE_7.get();
            }
            case SIZE_8: {
                return (MenuType)ContainerTypes.SUPPLY_CART_CONTAINER_SIZE_8.get();
            }
            case SIZE_9: {
                return (MenuType)ContainerTypes.SUPPLY_CART_CONTAINER_SIZE_9.get();
            }
            case SIZE_10: {
                return (MenuType)ContainerTypes.SUPPLY_CART_CONTAINER_SIZE_10.get();
            }
            case SIZE_11: {
                return (MenuType)ContainerTypes.SUPPLY_CART_CONTAINER_SIZE_11.get();
            }
            case SIZE_12: {
                return (MenuType)ContainerTypes.SUPPLY_CART_CONTAINER_SIZE_12.get();
            }
            case SIZE_13: {
                return (MenuType)ContainerTypes.SUPPLY_CART_CONTAINER_SIZE_13.get();
            }
        }
        return (MenuType)ContainerTypes.SUPPLY_CART_CONTAINER_SIZE_6.get();
    }

    public boolean isSmallerThan(ContainerList other) {
        return this.ordinal() < other.ordinal();
    }

    public boolean isEqualOrSmallerThan(ContainerList other) {
        return this.ordinal() <= other.ordinal();
    }

    public static MenuType<?> getMenuType(ContainerList container) {
        switch (container) {
            case SIZE_0: {
                return (MenuType)ContainerTypes.SUPPLY_CART_CONTAINER_SIZE_0.get();
            }
            case SIZE_1: {
                return (MenuType)ContainerTypes.SUPPLY_CART_CONTAINER_SIZE_1.get();
            }
            case SIZE_2: {
                return (MenuType)ContainerTypes.SUPPLY_CART_CONTAINER_SIZE_2.get();
            }
            case SIZE_3: {
                return (MenuType)ContainerTypes.SUPPLY_CART_CONTAINER_SIZE_3.get();
            }
            case SIZE_4: {
                return (MenuType)ContainerTypes.SUPPLY_CART_CONTAINER_SIZE_4.get();
            }
            case SIZE_5: {
                return (MenuType)ContainerTypes.SUPPLY_CART_CONTAINER_SIZE_5.get();
            }
            case SIZE_6: {
                return (MenuType)ContainerTypes.SUPPLY_CART_CONTAINER_SIZE_6.get();
            }
            case SIZE_7: {
                return (MenuType)ContainerTypes.SUPPLY_CART_CONTAINER_SIZE_7.get();
            }
            case SIZE_8: {
                return (MenuType)ContainerTypes.SUPPLY_CART_CONTAINER_SIZE_8.get();
            }
            case SIZE_9: {
                return (MenuType)ContainerTypes.SUPPLY_CART_CONTAINER_SIZE_9.get();
            }
            case SIZE_10: {
                return (MenuType)ContainerTypes.SUPPLY_CART_CONTAINER_SIZE_10.get();
            }
            case SIZE_11: {
                return (MenuType)ContainerTypes.SUPPLY_CART_CONTAINER_SIZE_11.get();
            }
            case SIZE_12: {
                return (MenuType)ContainerTypes.SUPPLY_CART_CONTAINER_SIZE_12.get();
            }
            case SIZE_13: {
                return (MenuType)ContainerTypes.SUPPLY_CART_CONTAINER_SIZE_13.get();
            }
        }
        return (MenuType)ContainerTypes.SUPPLY_CART_CONTAINER_SIZE_6.get();
    }

    public static int getRows(ContainerList container) {
        return container.getRows();
    }

    public static int getColumns(ContainerList container) {
        return container.getColumns();
    }

    public static int getSlots(ContainerList container) {
        return container.getSize();
    }

    static {
        VALUES = ContainerList.values();
    }
}

