/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.manyideas_core.elements.recipes.dyed_recipes;

import de.geheimagentnr1.manyideas_core.elements.block_state_properties.Color;
import de.geheimagentnr1.manyideas_core.elements.recipes.ModRecipeTypesRegisterFactory;
import de.geheimagentnr1.manyideas_core.elements.recipes.dyed_recipes.ColorIngredient;
import de.geheimagentnr1.manyideas_core.util.DyeBlockHelper;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class DyedRecipe
implements Recipe<CraftingContainer> {
    @NotNull
    public static final String registry_name = "dyed";
    @NotNull
    private final ResourceLocation id;
    @NotNull
    private final RecipeSerializer<?> serializer;
    private final boolean shaped;
    @NotNull
    private final NonNullList<Ingredient> ingredients;
    @NotNull
    private final ItemStack result;
    private final int recipeWidth;
    private final int recipeHeight;

    DyedRecipe(@NotNull ResourceLocation _id, @NotNull RecipeSerializer<?> _serializer, boolean _shaped, @NotNull NonNullList<Ingredient> _ingredients, @NotNull ItemStack _result, int _recipeWidth, int _recipeHeight) {
        this.id = _id;
        this.serializer = _serializer;
        this.shaped = _shaped;
        this.ingredients = _ingredients;
        this.result = _result;
        this.recipeWidth = _recipeWidth;
        this.recipeHeight = _recipeHeight;
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level level) {
        if (this.findMatchingColor(inv).isEmpty()) {
            return false;
        }
        if (this.shaped) {
            for (int i = 0; i < this.ingredients.size(); ++i) {
                if (((Ingredient)this.ingredients.get(i)).test(inv.m_8020_(i))) continue;
                return false;
            }
            return true;
        }
        ArrayList<ItemStack> inputItems = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            if (inv.m_8020_(i).m_41619_()) continue;
            inputItems.add(inv.m_8020_(i));
        }
        int found = 0;
        block2: for (Ingredient ingredient : this.ingredients) {
            for (int j = 0; j < inputItems.size(); ++j) {
                if (!ingredient.test((ItemStack)inputItems.get(j))) continue;
                inputItems.remove(j);
                ++found;
                continue block2;
            }
        }
        return found == this.ingredients.size() && inputItems.isEmpty();
    }

    @NotNull
    private Optional<Color> findMatchingColor(@NotNull CraftingContainer inv) {
        Color color = null;
        block0: for (Ingredient ingredient : this.ingredients) {
            if (!(ingredient instanceof ColorIngredient)) continue;
            for (int j = 0; j < inv.m_6643_(); ++j) {
                if (!ingredient.test(inv.m_8020_(j))) continue;
                ColorIngredient colorIngredient = (ColorIngredient)ingredient;
                Color newColor = colorIngredient.getColor(inv.m_8020_(j));
                if (newColor == null) {
                    return Optional.empty();
                }
                if (color == null) {
                    color = newColor;
                    continue block0;
                }
                if (color == newColor) continue block0;
                return Optional.empty();
            }
        }
        return color == null ? Optional.empty() : Optional.of(color);
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess registryAccess) {
        Optional<Color> color = this.findMatchingColor(inv);
        return color.map(value -> DyeBlockHelper.setColorToItemStack(this.result.m_41777_(), value)).orElse(ItemStack.f_41583_);
    }

    public boolean m_8004_(int width, int height) {
        if (this.shaped) {
            return width >= this.recipeWidth && height >= this.recipeHeight;
        }
        return width * height <= this.ingredients.size();
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return ModRecipeTypesRegisterFactory.DYED;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return this.serializer;
    }

    boolean isShaped() {
        return this.shaped;
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    @NotNull
    public ItemStack getResult() {
        return this.result;
    }

    int getRecipeWidth() {
        return this.recipeWidth;
    }

    int getRecipeHeight() {
        return this.recipeHeight;
    }
}

