/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.manyideas_core.elements.items.tools.redstone_key.screen;

import de.geheimagentnr1.manyideas_core.elements.items.ModItemsRegisterFactory;
import de.geheimagentnr1.manyideas_core.elements.items.tools.redstone_key.interfaces.RedstoneKeyable;
import de.geheimagentnr1.manyideas_core.elements.items.tools.redstone_key.models.Option;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class RedstoneKeyContainer
extends AbstractContainerMenu {
    @NotNull
    private final ResourceLocation icons;
    @NotNull
    private final BlockPos pos;
    @NotNull
    private final RedstoneKeyable redstoneKeyableBlock;
    @NotNull
    private final List<Option> options;
    private int selectedIndex;

    public RedstoneKeyContainer(int windowId, @NotNull ResourceLocation _icons, @NotNull BlockPos _pos, @NotNull RedstoneKeyable _redstoneKeyableBlock, @NotNull List<Option> _options, int _selectedIndex) {
        super(ModItemsRegisterFactory.RESTONE_KEY_CONTAINER, windowId);
        this.icons = _icons;
        this.pos = _pos;
        this.redstoneKeyableBlock = _redstoneKeyableBlock;
        this.options = _options;
        this.selectedIndex = _selectedIndex;
    }

    public RedstoneKeyContainer(int windowId, @NotNull FriendlyByteBuf data) {
        super(ModItemsRegisterFactory.RESTONE_KEY_CONTAINER, windowId);
        this.icons = data.m_130281_();
        this.pos = data.m_130135_();
        this.redstoneKeyableBlock = (RedstoneKeyable)Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_8055_(this.pos).m_60734_();
        int optionsCount = data.readInt();
        this.options = new ArrayList<Option>();
        for (int i = 0; i < optionsCount; ++i) {
            this.options.add(new Option(data.m_130277_(), data.m_130277_()));
        }
        this.selectedIndex = data.readInt();
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(@NotNull Player player) {
        return true;
    }

    @NotNull
    public ResourceLocation getIcons() {
        return this.icons;
    }

    @NotNull
    public List<Option> getOptions() {
        return this.options;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int _selected) {
        this.selectedIndex = _selected;
    }

    public void setBlockStateValue(@NotNull Level level, int stateIndex, @NotNull Player player) {
        this.selectedIndex = stateIndex;
        BlockState state = level.m_8055_(this.pos);
        Block block = state.m_60734_();
        if (block == this.redstoneKeyableBlock) {
            this.redstoneKeyableBlock.setBlockStateValue(level, state, this.pos, stateIndex, player);
        }
    }
}

